/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.ForecastResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ForecastRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String duration;
    @Nullable
    private final String expiresIn;
    public static final JsonpDeserializer<ForecastRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForecastRequest::setupForecastRequestDeserializer, Builder::build);
    public static final Endpoint<ForecastRequest, ForecastResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ForecastRequest, ForecastResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ForecastResponse._DESERIALIZER);

    public ForecastRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.duration = builder.duration;
        this.expiresIn = builder.expiresIn;
    }

    public ForecastRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String duration() {
        return this.duration;
    }

    @Nullable
    public String expiresIn() {
        return this.expiresIn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.duration != null) {
            generator.writeKey("duration");
            generator.write(this.duration);
        }
        if (this.expiresIn != null) {
            generator.writeKey("expires_in");
            generator.write(this.expiresIn);
        }
    }

    protected static void setupForecastRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::duration, JsonpDeserializer.stringDeserializer(), "duration", new String[0]);
        op.add(Builder::expiresIn, JsonpDeserializer.stringDeserializer(), "expires_in", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ForecastRequest> {
        private String jobId;
        @Nullable
        private String duration;
        @Nullable
        private String expiresIn;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder duration(@Nullable String value) {
            this.duration = value;
            return this;
        }

        public Builder expiresIn(@Nullable String value) {
            this.expiresIn = value;
            return this;
        }

        @Override
        public ForecastRequest build() {
            return new ForecastRequest(this);
        }
    }
}

