/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.BucketSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetBucketsResponse
implements JsonpSerializable {
    private final List<BucketSummary> buckets;
    private final long count;
    public static final JsonpDeserializer<GetBucketsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetBucketsResponse::setupGetBucketsResponseDeserializer, Builder::build);

    public GetBucketsResponse(Builder builder) {
        this.buckets = ModelTypeHelper.unmodifiableNonNull(builder.buckets, "buckets");
        this.count = Objects.requireNonNull(builder.count, "count");
    }

    public GetBucketsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<BucketSummary> buckets() {
        return this.buckets;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("buckets");
        generator.writeStartArray();
        for (BucketSummary item0 : this.buckets) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("count");
        generator.write(this.count);
    }

    protected static void setupGetBucketsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::buckets, JsonpDeserializer.arrayDeserializer(BucketSummary._DESERIALIZER), "buckets", new String[0]);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetBucketsResponse> {
        private List<BucketSummary> buckets;
        private Long count;

        public Builder buckets(List<BucketSummary> value) {
            this.buckets = value;
            return this;
        }

        public Builder buckets(BucketSummary ... value) {
            this.buckets = Arrays.asList(value);
            return this;
        }

        public Builder addBuckets(BucketSummary value) {
            if (this.buckets == null) {
                this.buckets = new ArrayList<BucketSummary>();
            }
            this.buckets.add(value);
            return this;
        }

        public Builder buckets(Function<BucketSummary.Builder, ObjectBuilder<BucketSummary>> fn) {
            return this.buckets(fn.apply(new BucketSummary.Builder()).build());
        }

        public Builder addBuckets(Function<BucketSummary.Builder, ObjectBuilder<BucketSummary>> fn) {
            return this.addBuckets(fn.apply(new BucketSummary.Builder()).build());
        }

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        public GetBucketsResponse build() {
            return new GetBucketsResponse(this);
        }
    }
}

