/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataCounts;
import co.elastic.clients.elasticsearch.ml.DiscoveryNode;
import co.elastic.clients.elasticsearch.ml.JobForecastStatistics;
import co.elastic.clients.elasticsearch.ml.JobState;
import co.elastic.clients.elasticsearch.ml.JobTimingStats;
import co.elastic.clients.elasticsearch.ml.ModelSizeStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class JobStats
implements JsonpSerializable {
    private final String assignmentExplanation;
    private final DataCounts dataCounts;
    private final JobForecastStatistics forecastsStats;
    private final String jobId;
    private final ModelSizeStats modelSizeStats;
    private final DiscoveryNode node;
    @Nullable
    private final String openTime;
    private final JobState state;
    private final JobTimingStats timingStats;
    @Nullable
    private final Boolean deleting;
    public static final JsonpDeserializer<JobStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobStats::setupJobStatsDeserializer, Builder::build);

    public JobStats(Builder builder) {
        this.assignmentExplanation = Objects.requireNonNull(builder.assignmentExplanation, "assignment_explanation");
        this.dataCounts = Objects.requireNonNull(builder.dataCounts, "data_counts");
        this.forecastsStats = Objects.requireNonNull(builder.forecastsStats, "forecasts_stats");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.modelSizeStats = Objects.requireNonNull(builder.modelSizeStats, "model_size_stats");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.openTime = builder.openTime;
        this.state = Objects.requireNonNull(builder.state, "state");
        this.timingStats = Objects.requireNonNull(builder.timingStats, "timing_stats");
        this.deleting = builder.deleting;
    }

    public JobStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public DataCounts dataCounts() {
        return this.dataCounts;
    }

    public JobForecastStatistics forecastsStats() {
        return this.forecastsStats;
    }

    public String jobId() {
        return this.jobId;
    }

    public ModelSizeStats modelSizeStats() {
        return this.modelSizeStats;
    }

    public DiscoveryNode node() {
        return this.node;
    }

    @Nullable
    public String openTime() {
        return this.openTime;
    }

    public JobState state() {
        return this.state;
    }

    public JobTimingStats timingStats() {
        return this.timingStats;
    }

    @Nullable
    public Boolean deleting() {
        return this.deleting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("assignment_explanation");
        generator.write(this.assignmentExplanation);
        generator.writeKey("data_counts");
        this.dataCounts.serialize(generator, mapper);
        generator.writeKey("forecasts_stats");
        this.forecastsStats.serialize(generator, mapper);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("model_size_stats");
        this.modelSizeStats.serialize(generator, mapper);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        if (this.openTime != null) {
            generator.writeKey("open_time");
            generator.write(this.openTime);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("timing_stats");
        this.timingStats.serialize(generator, mapper);
        if (this.deleting != null) {
            generator.writeKey("deleting");
            generator.write(this.deleting.booleanValue());
        }
    }

    protected static void setupJobStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation", new String[0]);
        op.add(Builder::dataCounts, DataCounts._DESERIALIZER, "data_counts", new String[0]);
        op.add(Builder::forecastsStats, JobForecastStatistics._DESERIALIZER, "forecasts_stats", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::modelSizeStats, ModelSizeStats._DESERIALIZER, "model_size_stats", new String[0]);
        op.add(Builder::node, DiscoveryNode._DESERIALIZER, "node", new String[0]);
        op.add(Builder::openTime, JsonpDeserializer.stringDeserializer(), "open_time", new String[0]);
        op.add(Builder::state, JobState._DESERIALIZER, "state", new String[0]);
        op.add(Builder::timingStats, JobTimingStats._DESERIALIZER, "timing_stats", new String[0]);
        op.add(Builder::deleting, JsonpDeserializer.booleanDeserializer(), "deleting", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JobStats> {
        private String assignmentExplanation;
        private DataCounts dataCounts;
        private JobForecastStatistics forecastsStats;
        private String jobId;
        private ModelSizeStats modelSizeStats;
        private DiscoveryNode node;
        @Nullable
        private String openTime;
        private JobState state;
        private JobTimingStats timingStats;
        @Nullable
        private Boolean deleting;

        public Builder assignmentExplanation(String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public Builder dataCounts(DataCounts value) {
            this.dataCounts = value;
            return this;
        }

        public Builder dataCounts(Function<DataCounts.Builder, ObjectBuilder<DataCounts>> fn) {
            return this.dataCounts(fn.apply(new DataCounts.Builder()).build());
        }

        public Builder forecastsStats(JobForecastStatistics value) {
            this.forecastsStats = value;
            return this;
        }

        public Builder forecastsStats(Function<JobForecastStatistics.Builder, ObjectBuilder<JobForecastStatistics>> fn) {
            return this.forecastsStats(fn.apply(new JobForecastStatistics.Builder()).build());
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder modelSizeStats(ModelSizeStats value) {
            this.modelSizeStats = value;
            return this;
        }

        public Builder modelSizeStats(Function<ModelSizeStats.Builder, ObjectBuilder<ModelSizeStats>> fn) {
            return this.modelSizeStats(fn.apply(new ModelSizeStats.Builder()).build());
        }

        public Builder node(DiscoveryNode value) {
            this.node = value;
            return this;
        }

        public Builder node(Function<DiscoveryNode.Builder, ObjectBuilder<DiscoveryNode>> fn) {
            return this.node(fn.apply(new DiscoveryNode.Builder()).build());
        }

        public Builder openTime(@Nullable String value) {
            this.openTime = value;
            return this;
        }

        public Builder state(JobState value) {
            this.state = value;
            return this;
        }

        public Builder timingStats(JobTimingStats value) {
            this.timingStats = value;
            return this;
        }

        public Builder timingStats(Function<JobTimingStats.Builder, ObjectBuilder<JobTimingStats>> fn) {
            return this.timingStats(fn.apply(new JobTimingStats.Builder()).build());
        }

        public Builder deleting(@Nullable Boolean value) {
            this.deleting = value;
            return this;
        }

        @Override
        public JobStats build() {
            return new JobStats(this);
        }
    }
}

