/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ModelSizeStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ModelSnapshot
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String jobId;
    private final int latestRecordTimeStamp;
    private final int latestResultTimeStamp;
    private final String minVersion;
    private final ModelSizeStats modelSizeStats;
    private final boolean retain;
    private final long snapshotDocCount;
    private final String snapshotId;
    private final int timestamp;
    public static final JsonpDeserializer<ModelSnapshot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelSnapshot::setupModelSnapshotDeserializer, Builder::build);

    public ModelSnapshot(Builder builder) {
        this.description = builder.description;
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.latestRecordTimeStamp = Objects.requireNonNull(builder.latestRecordTimeStamp, "latest_record_time_stamp");
        this.latestResultTimeStamp = Objects.requireNonNull(builder.latestResultTimeStamp, "latest_result_time_stamp");
        this.minVersion = Objects.requireNonNull(builder.minVersion, "min_version");
        this.modelSizeStats = Objects.requireNonNull(builder.modelSizeStats, "model_size_stats");
        this.retain = Objects.requireNonNull(builder.retain, "retain");
        this.snapshotDocCount = Objects.requireNonNull(builder.snapshotDocCount, "snapshot_doc_count");
        this.snapshotId = Objects.requireNonNull(builder.snapshotId, "snapshot_id");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public ModelSnapshot(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public String jobId() {
        return this.jobId;
    }

    public int latestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public int latestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public String minVersion() {
        return this.minVersion;
    }

    public ModelSizeStats modelSizeStats() {
        return this.modelSizeStats;
    }

    public boolean retain() {
        return this.retain;
    }

    public long snapshotDocCount() {
        return this.snapshotDocCount;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public int timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("latest_record_time_stamp");
        generator.write(this.latestRecordTimeStamp);
        generator.writeKey("latest_result_time_stamp");
        generator.write(this.latestResultTimeStamp);
        generator.writeKey("min_version");
        generator.write(this.minVersion);
        generator.writeKey("model_size_stats");
        this.modelSizeStats.serialize(generator, mapper);
        generator.writeKey("retain");
        generator.write(this.retain);
        generator.writeKey("snapshot_doc_count");
        generator.write(this.snapshotDocCount);
        generator.writeKey("snapshot_id");
        generator.write(this.snapshotId);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupModelSnapshotDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::latestRecordTimeStamp, JsonpDeserializer.integerDeserializer(), "latest_record_time_stamp", new String[0]);
        op.add(Builder::latestResultTimeStamp, JsonpDeserializer.integerDeserializer(), "latest_result_time_stamp", new String[0]);
        op.add(Builder::minVersion, JsonpDeserializer.stringDeserializer(), "min_version", new String[0]);
        op.add(Builder::modelSizeStats, ModelSizeStats._DESERIALIZER, "model_size_stats", new String[0]);
        op.add(Builder::retain, JsonpDeserializer.booleanDeserializer(), "retain", new String[0]);
        op.add(Builder::snapshotDocCount, JsonpDeserializer.longDeserializer(), "snapshot_doc_count", new String[0]);
        op.add(Builder::snapshotId, JsonpDeserializer.stringDeserializer(), "snapshot_id", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.integerDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ModelSnapshot> {
        @Nullable
        private String description;
        private String jobId;
        private Integer latestRecordTimeStamp;
        private Integer latestResultTimeStamp;
        private String minVersion;
        private ModelSizeStats modelSizeStats;
        private Boolean retain;
        private Long snapshotDocCount;
        private String snapshotId;
        private Integer timestamp;

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder latestRecordTimeStamp(int value) {
            this.latestRecordTimeStamp = value;
            return this;
        }

        public Builder latestResultTimeStamp(int value) {
            this.latestResultTimeStamp = value;
            return this;
        }

        public Builder minVersion(String value) {
            this.minVersion = value;
            return this;
        }

        public Builder modelSizeStats(ModelSizeStats value) {
            this.modelSizeStats = value;
            return this;
        }

        public Builder modelSizeStats(Function<ModelSizeStats.Builder, ObjectBuilder<ModelSizeStats>> fn) {
            return this.modelSizeStats(fn.apply(new ModelSizeStats.Builder()).build());
        }

        public Builder retain(boolean value) {
            this.retain = value;
            return this;
        }

        public Builder snapshotDocCount(long value) {
            this.snapshotDocCount = value;
            return this;
        }

        public Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public Builder timestamp(int value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public ModelSnapshot build() {
            return new ModelSnapshot(this);
        }
    }
}

