/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PreviewDatafeedResponse<TDocument>
implements JsonpSerializable {
    private final List<TDocument> data;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public PreviewDatafeedResponse(Builder<TDocument> builder) {
        this.data = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).data, "data");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public PreviewDatafeedResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public List<TDocument> data() {
        return this.data;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data");
        generator.writeStartArray();
        for (TDocument item0 : this.data) {
            JsonpUtils.serialize(item0, generator, this.tDocumentSerializer, mapper);
        }
        generator.writeEnd();
    }

    public static <TDocument> JsonpDeserializer<PreviewDatafeedResponse<TDocument>> createPreviewDatafeedResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> PreviewDatafeedResponse.setupPreviewDatafeedResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupPreviewDatafeedResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(tDocumentDeserializer), "data", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<PreviewDatafeedResponse<TDocument>> {
        private List<TDocument> data;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> data(List<TDocument> value) {
            this.data = value;
            return this;
        }

        public Builder<TDocument> data(TDocument ... value) {
            this.data = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addData(TDocument value) {
            if (this.data == null) {
                this.data = new ArrayList<TDocument>();
            }
            this.data.add(value);
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public PreviewDatafeedResponse<TDocument> build() {
            return new PreviewDatafeedResponse(this);
        }
    }
}

