/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.ResetJobResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ResetJobRequest
extends RequestBase {
    private final String jobId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ResetJobRequest, ResetJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ResetJobRequest, ResetJobResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_reset");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ResetJobResponse._DESERIALIZER);

    public ResetJobRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public ResetJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<ResetJobRequest> {
        private String jobId;
        @Nullable
        private Boolean waitForCompletion;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public ResetJobRequest build() {
            return new ResetJobRequest(this);
        }
    }
}

