/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Cpu
implements JsonpSerializable {
    private final int percent;
    @Nullable
    private final String sys;
    @Nullable
    private final Long sysInMillis;
    @Nullable
    private final String total;
    @Nullable
    private final Long totalInMillis;
    @Nullable
    private final String user;
    @Nullable
    private final Long userInMillis;
    @Nullable
    private final Map<String, Double> loadAverage;
    public static final JsonpDeserializer<Cpu> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Cpu::setupCpuDeserializer, Builder::build);

    public Cpu(Builder builder) {
        this.percent = Objects.requireNonNull(builder.percent, "percent");
        this.sys = builder.sys;
        this.sysInMillis = builder.sysInMillis;
        this.total = builder.total;
        this.totalInMillis = builder.totalInMillis;
        this.user = builder.user;
        this.userInMillis = builder.userInMillis;
        this.loadAverage = ModelTypeHelper.unmodifiable(builder.loadAverage);
    }

    public Cpu(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int percent() {
        return this.percent;
    }

    @Nullable
    public String sys() {
        return this.sys;
    }

    @Nullable
    public Long sysInMillis() {
        return this.sysInMillis;
    }

    @Nullable
    public String total() {
        return this.total;
    }

    @Nullable
    public Long totalInMillis() {
        return this.totalInMillis;
    }

    @Nullable
    public String user() {
        return this.user;
    }

    @Nullable
    public Long userInMillis() {
        return this.userInMillis;
    }

    @Nullable
    public Map<String, Double> loadAverage() {
        return this.loadAverage;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        if (this.sys != null) {
            generator.writeKey("sys");
            generator.write(this.sys);
        }
        if (this.sysInMillis != null) {
            generator.writeKey("sys_in_millis");
            generator.write(this.sysInMillis.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.totalInMillis != null) {
            generator.writeKey("total_in_millis");
            generator.write(this.totalInMillis.longValue());
        }
        if (this.user != null) {
            generator.writeKey("user");
            generator.write(this.user);
        }
        if (this.userInMillis != null) {
            generator.writeKey("user_in_millis");
            generator.write(this.userInMillis.longValue());
        }
        if (this.loadAverage != null) {
            generator.writeKey("load_average");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.loadAverage.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupCpuDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.integerDeserializer(), "percent", new String[0]);
        op.add(Builder::sys, JsonpDeserializer.stringDeserializer(), "sys", new String[0]);
        op.add(Builder::sysInMillis, JsonpDeserializer.longDeserializer(), "sys_in_millis", new String[0]);
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total", new String[0]);
        op.add(Builder::totalInMillis, JsonpDeserializer.longDeserializer(), "total_in_millis", new String[0]);
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user", new String[0]);
        op.add(Builder::userInMillis, JsonpDeserializer.longDeserializer(), "user_in_millis", new String[0]);
        op.add(Builder::loadAverage, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "load_average", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Cpu> {
        private Integer percent;
        @Nullable
        private String sys;
        @Nullable
        private Long sysInMillis;
        @Nullable
        private String total;
        @Nullable
        private Long totalInMillis;
        @Nullable
        private String user;
        @Nullable
        private Long userInMillis;
        @Nullable
        private Map<String, Double> loadAverage;

        public Builder percent(int value) {
            this.percent = value;
            return this;
        }

        public Builder sys(@Nullable String value) {
            this.sys = value;
            return this;
        }

        public Builder sysInMillis(@Nullable Long value) {
            this.sysInMillis = value;
            return this;
        }

        public Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public Builder totalInMillis(@Nullable Long value) {
            this.totalInMillis = value;
            return this;
        }

        public Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        public Builder userInMillis(@Nullable Long value) {
            this.userInMillis = value;
            return this;
        }

        public Builder loadAverage(@Nullable Map<String, Double> value) {
            this.loadAverage = value;
            return this;
        }

        public Builder putLoadAverage(String key, Double value) {
            if (this.loadAverage == null) {
                this.loadAverage = new HashMap<String, Double>();
            }
            this.loadAverage.put(key, value);
            return this;
        }

        @Override
        public Cpu build() {
            return new Cpu(this);
        }
    }
}

