/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FileSystemTotal
implements JsonpSerializable {
    private final String available;
    private final long availableInBytes;
    private final String free;
    private final long freeInBytes;
    private final String total;
    private final long totalInBytes;
    public static final JsonpDeserializer<FileSystemTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystemTotal::setupFileSystemTotalDeserializer, Builder::build);

    public FileSystemTotal(Builder builder) {
        this.available = Objects.requireNonNull(builder.available, "available");
        this.availableInBytes = Objects.requireNonNull(builder.availableInBytes, "available_in_bytes");
        this.free = Objects.requireNonNull(builder.free, "free");
        this.freeInBytes = Objects.requireNonNull(builder.freeInBytes, "free_in_bytes");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
    }

    public FileSystemTotal(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String available() {
        return this.available;
    }

    public long availableInBytes() {
        return this.availableInBytes;
    }

    public String free() {
        return this.free;
    }

    public long freeInBytes() {
        return this.freeInBytes;
    }

    public String total() {
        return this.total;
    }

    public long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free");
        generator.write(this.free);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupFileSystemTotalDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available", new String[0]);
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes", new String[0]);
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free", new String[0]);
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes", new String[0]);
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FileSystemTotal> {
        private String available;
        private Long availableInBytes;
        private String free;
        private Long freeInBytes;
        private String total;
        private Long totalInBytes;

        public Builder available(String value) {
            this.available = value;
            return this;
        }

        public Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public Builder free(String value) {
            this.free = value;
            return this;
        }

        public Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public Builder total(String value) {
            this.total = value;
            return this;
        }

        public Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public FileSystemTotal build() {
            return new FileSystemTotal(this);
        }
    }
}

