/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GarbageCollectorTotal
implements JsonpSerializable {
    private final long collectionCount;
    private final String collectionTime;
    private final long collectionTimeInMillis;
    public static final JsonpDeserializer<GarbageCollectorTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollectorTotal::setupGarbageCollectorTotalDeserializer, Builder::build);

    public GarbageCollectorTotal(Builder builder) {
        this.collectionCount = Objects.requireNonNull(builder.collectionCount, "collection_count");
        this.collectionTime = Objects.requireNonNull(builder.collectionTime, "collection_time");
        this.collectionTimeInMillis = Objects.requireNonNull(builder.collectionTimeInMillis, "collection_time_in_millis");
    }

    public GarbageCollectorTotal(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long collectionCount() {
        return this.collectionCount;
    }

    public String collectionTime() {
        return this.collectionTime;
    }

    public long collectionTimeInMillis() {
        return this.collectionTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collection_count");
        generator.write(this.collectionCount);
        generator.writeKey("collection_time");
        generator.write(this.collectionTime);
        generator.writeKey("collection_time_in_millis");
        generator.write(this.collectionTimeInMillis);
    }

    protected static void setupGarbageCollectorTotalDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::collectionCount, JsonpDeserializer.longDeserializer(), "collection_count", new String[0]);
        op.add(Builder::collectionTime, JsonpDeserializer.stringDeserializer(), "collection_time", new String[0]);
        op.add(Builder::collectionTimeInMillis, JsonpDeserializer.longDeserializer(), "collection_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GarbageCollectorTotal> {
        private Long collectionCount;
        private String collectionTime;
        private Long collectionTimeInMillis;

        public Builder collectionCount(long value) {
            this.collectionCount = value;
            return this;
        }

        public Builder collectionTime(String value) {
            this.collectionTime = value;
            return this;
        }

        public Builder collectionTimeInMillis(long value) {
            this.collectionTimeInMillis = value;
            return this;
        }

        @Override
        public GarbageCollectorTotal build() {
            return new GarbageCollectorTotal(this);
        }
    }
}

