/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class JvmClasses
implements JsonpSerializable {
    private final long currentLoadedCount;
    private final long totalLoadedCount;
    private final long totalUnloadedCount;
    public static final JsonpDeserializer<JvmClasses> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmClasses::setupJvmClassesDeserializer, Builder::build);

    public JvmClasses(Builder builder) {
        this.currentLoadedCount = Objects.requireNonNull(builder.currentLoadedCount, "current_loaded_count");
        this.totalLoadedCount = Objects.requireNonNull(builder.totalLoadedCount, "total_loaded_count");
        this.totalUnloadedCount = Objects.requireNonNull(builder.totalUnloadedCount, "total_unloaded_count");
    }

    public JvmClasses(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long currentLoadedCount() {
        return this.currentLoadedCount;
    }

    public long totalLoadedCount() {
        return this.totalLoadedCount;
    }

    public long totalUnloadedCount() {
        return this.totalUnloadedCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_loaded_count");
        generator.write(this.currentLoadedCount);
        generator.writeKey("total_loaded_count");
        generator.write(this.totalLoadedCount);
        generator.writeKey("total_unloaded_count");
        generator.write(this.totalUnloadedCount);
    }

    protected static void setupJvmClassesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentLoadedCount, JsonpDeserializer.longDeserializer(), "current_loaded_count", new String[0]);
        op.add(Builder::totalLoadedCount, JsonpDeserializer.longDeserializer(), "total_loaded_count", new String[0]);
        op.add(Builder::totalUnloadedCount, JsonpDeserializer.longDeserializer(), "total_unloaded_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<JvmClasses> {
        private Long currentLoadedCount;
        private Long totalLoadedCount;
        private Long totalUnloadedCount;

        public Builder currentLoadedCount(long value) {
            this.currentLoadedCount = value;
            return this;
        }

        public Builder totalLoadedCount(long value) {
            this.totalLoadedCount = value;
            return this;
        }

        public Builder totalUnloadedCount(long value) {
            this.totalUnloadedCount = value;
            return this;
        }

        @Override
        public JvmClasses build() {
            return new JvmClasses(this);
        }
    }
}

