/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoIngestProcessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoIngest
implements JsonpSerializable {
    private final List<NodeInfoIngestProcessor> processors;
    public static final JsonpDeserializer<NodeInfoIngest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoIngest::setupNodeInfoIngestDeserializer, Builder::build);

    public NodeInfoIngest(Builder builder) {
        this.processors = ModelTypeHelper.unmodifiableNonNull(builder.processors, "processors");
    }

    public NodeInfoIngest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<NodeInfoIngestProcessor> processors() {
        return this.processors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("processors");
        generator.writeStartArray();
        for (NodeInfoIngestProcessor item0 : this.processors) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupNodeInfoIngestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(NodeInfoIngestProcessor._DESERIALIZER), "processors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoIngest> {
        private List<NodeInfoIngestProcessor> processors;

        public Builder processors(List<NodeInfoIngestProcessor> value) {
            this.processors = value;
            return this;
        }

        public Builder processors(NodeInfoIngestProcessor ... value) {
            this.processors = Arrays.asList(value);
            return this;
        }

        public Builder addProcessors(NodeInfoIngestProcessor value) {
            if (this.processors == null) {
                this.processors = new ArrayList<NodeInfoIngestProcessor>();
            }
            this.processors.add(value);
            return this;
        }

        public Builder processors(Function<NodeInfoIngestProcessor.Builder, ObjectBuilder<NodeInfoIngestProcessor>> fn) {
            return this.processors(fn.apply(new NodeInfoIngestProcessor.Builder()).build());
        }

        public Builder addProcessors(Function<NodeInfoIngestProcessor.Builder, ObjectBuilder<NodeInfoIngestProcessor>> fn) {
            return this.addProcessors(fn.apply(new NodeInfoIngestProcessor.Builder()).build());
        }

        @Override
        public NodeInfoIngest build() {
            return new NodeInfoIngest(this);
        }
    }
}

