/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoSettingsNode
implements JsonpSerializable {
    private final String name;
    private final Map<String, JsonData> attr;
    @Nullable
    private final String maxLocalStorageNodes;
    public static final JsonpDeserializer<NodeInfoSettingsNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsNode::setupNodeInfoSettingsNodeDeserializer, Builder::build);

    public NodeInfoSettingsNode(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.attr = ModelTypeHelper.unmodifiableNonNull(builder.attr, "attr");
        this.maxLocalStorageNodes = builder.maxLocalStorageNodes;
    }

    public NodeInfoSettingsNode(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public Map<String, JsonData> attr() {
        return this.attr;
    }

    @Nullable
    public String maxLocalStorageNodes() {
        return this.maxLocalStorageNodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("attr");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.attr.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.maxLocalStorageNodes != null) {
            generator.writeKey("max_local_storage_nodes");
            generator.write(this.maxLocalStorageNodes);
        }
    }

    protected static void setupNodeInfoSettingsNodeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::attr, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "attr", new String[0]);
        op.add(Builder::maxLocalStorageNodes, JsonpDeserializer.stringDeserializer(), "max_local_storage_nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoSettingsNode> {
        private String name;
        private Map<String, JsonData> attr;
        @Nullable
        private String maxLocalStorageNodes;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder attr(Map<String, JsonData> value) {
            this.attr = value;
            return this;
        }

        public Builder putAttr(String key, JsonData value) {
            if (this.attr == null) {
                this.attr = new HashMap<String, JsonData>();
            }
            this.attr.put(key, value);
            return this;
        }

        public Builder maxLocalStorageNodes(@Nullable String value) {
            this.maxLocalStorageNodes = value;
            return this;
        }

        @Override
        public NodeInfoSettingsNode build() {
            return new NodeInfoSettingsNode(this);
        }
    }
}

