/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoTransport
implements JsonpSerializable {
    private final List<String> boundAddress;
    private final String publishAddress;
    private final Map<String, String> profiles;
    public static final JsonpDeserializer<NodeInfoTransport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoTransport::setupNodeInfoTransportDeserializer, Builder::build);

    public NodeInfoTransport(Builder builder) {
        this.boundAddress = ModelTypeHelper.unmodifiableNonNull(builder.boundAddress, "bound_address");
        this.publishAddress = Objects.requireNonNull(builder.publishAddress, "publish_address");
        this.profiles = ModelTypeHelper.unmodifiableNonNull(builder.profiles, "profiles");
    }

    public NodeInfoTransport(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> boundAddress() {
        return this.boundAddress;
    }

    public String publishAddress() {
        return this.publishAddress;
    }

    public Map<String, String> profiles() {
        return this.profiles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bound_address");
        generator.writeStartArray();
        for (String string : this.boundAddress) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
        generator.writeKey("profiles");
        generator.writeStartObject();
        for (Map.Entry entry : this.profiles.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
    }

    protected static void setupNodeInfoTransportDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address", new String[0]);
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address", new String[0]);
        op.add(Builder::profiles, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "profiles", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoTransport> {
        private List<String> boundAddress;
        private String publishAddress;
        private Map<String, String> profiles;

        public Builder boundAddress(List<String> value) {
            this.boundAddress = value;
            return this;
        }

        public Builder boundAddress(String ... value) {
            this.boundAddress = Arrays.asList(value);
            return this;
        }

        public Builder addBoundAddress(String value) {
            if (this.boundAddress == null) {
                this.boundAddress = new ArrayList<String>();
            }
            this.boundAddress.add(value);
            return this;
        }

        public Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        public Builder profiles(Map<String, String> value) {
            this.profiles = value;
            return this;
        }

        public Builder putProfiles(String key, String value) {
            if (this.profiles == null) {
                this.profiles = new HashMap<String, String>();
            }
            this.profiles.put(key, value);
            return this;
        }

        @Override
        public NodeInfoTransport build() {
            return new NodeInfoTransport(this);
        }
    }
}

