/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch.rollup.get_jobs.RollupJob;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetJobsResponse
implements JsonpSerializable {
    private final List<RollupJob> jobs;
    public static final JsonpDeserializer<GetJobsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetJobsResponse::setupGetJobsResponseDeserializer, Builder::build);

    public GetJobsResponse(Builder builder) {
        this.jobs = ModelTypeHelper.unmodifiableNonNull(builder.jobs, "jobs");
    }

    public GetJobsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<RollupJob> jobs() {
        return this.jobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("jobs");
        generator.writeStartArray();
        for (RollupJob item0 : this.jobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetJobsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(RollupJob._DESERIALIZER), "jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetJobsResponse> {
        private List<RollupJob> jobs;

        public Builder jobs(List<RollupJob> value) {
            this.jobs = value;
            return this;
        }

        public Builder jobs(RollupJob ... value) {
            this.jobs = Arrays.asList(value);
            return this;
        }

        public Builder addJobs(RollupJob value) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<RollupJob>();
            }
            this.jobs.add(value);
            return this;
        }

        public Builder jobs(Function<RollupJob.Builder, ObjectBuilder<RollupJob>> fn) {
            return this.jobs(fn.apply(new RollupJob.Builder()).build());
        }

        public Builder addJobs(Function<RollupJob.Builder, ObjectBuilder<RollupJob>> fn) {
            return this.addJobs(fn.apply(new RollupJob.Builder()).build());
        }

        @Override
        public GetJobsResponse build() {
            return new GetJobsResponse(this);
        }
    }
}

