/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.rollup.FieldMetric;
import co.elastic.clients.elasticsearch.rollup.Groupings;
import co.elastic.clients.elasticsearch.rollup.PutJobResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutJobRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String cron;
    @Nullable
    private final Groupings groups;
    @Nullable
    private final String indexPattern;
    @Nullable
    private final List<FieldMetric> metrics;
    @Nullable
    private final Long pageSize;
    @Nullable
    private final String rollupIndex;
    public static final JsonpDeserializer<PutJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJobRequest::setupPutJobRequestDeserializer, Builder::build);
    public static final Endpoint<PutJobRequest, PutJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutJobRequest, PutJobResponse>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rollup");
            buf.append("/job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutJobResponse._DESERIALIZER);

    public PutJobRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.cron = builder.cron;
        this.groups = builder.groups;
        this.indexPattern = builder.indexPattern;
        this.metrics = ModelTypeHelper.unmodifiable(builder.metrics);
        this.pageSize = builder.pageSize;
        this.rollupIndex = builder.rollupIndex;
    }

    public PutJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String cron() {
        return this.cron;
    }

    @Nullable
    public Groupings groups() {
        return this.groups;
    }

    @Nullable
    public String indexPattern() {
        return this.indexPattern;
    }

    @Nullable
    public List<FieldMetric> metrics() {
        return this.metrics;
    }

    @Nullable
    public Long pageSize() {
        return this.pageSize;
    }

    @Nullable
    public String rollupIndex() {
        return this.rollupIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cron != null) {
            generator.writeKey("cron");
            generator.write(this.cron);
        }
        if (this.groups != null) {
            generator.writeKey("groups");
            this.groups.serialize(generator, mapper);
        }
        if (this.indexPattern != null) {
            generator.writeKey("index_pattern");
            generator.write(this.indexPattern);
        }
        if (this.metrics != null) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (FieldMetric item0 : this.metrics) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pageSize != null) {
            generator.writeKey("page_size");
            generator.write(this.pageSize.longValue());
        }
        if (this.rollupIndex != null) {
            generator.writeKey("rollup_index");
            generator.write(this.rollupIndex);
        }
    }

    protected static void setupPutJobRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron", new String[0]);
        op.add(Builder::groups, Groupings._DESERIALIZER, "groups", new String[0]);
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern", new String[0]);
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(FieldMetric._DESERIALIZER), "metrics", new String[0]);
        op.add(Builder::pageSize, JsonpDeserializer.longDeserializer(), "page_size", new String[0]);
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutJobRequest> {
        private String id;
        @Nullable
        private String cron;
        @Nullable
        private Groupings groups;
        @Nullable
        private String indexPattern;
        @Nullable
        private List<FieldMetric> metrics;
        @Nullable
        private Long pageSize;
        @Nullable
        private String rollupIndex;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder cron(@Nullable String value) {
            this.cron = value;
            return this;
        }

        public Builder groups(@Nullable Groupings value) {
            this.groups = value;
            return this;
        }

        public Builder groups(Function<Groupings.Builder, ObjectBuilder<Groupings>> fn) {
            return this.groups(fn.apply(new Groupings.Builder()).build());
        }

        public Builder indexPattern(@Nullable String value) {
            this.indexPattern = value;
            return this;
        }

        public Builder metrics(@Nullable List<FieldMetric> value) {
            this.metrics = value;
            return this;
        }

        public Builder metrics(FieldMetric ... value) {
            this.metrics = Arrays.asList(value);
            return this;
        }

        public Builder addMetrics(FieldMetric value) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<FieldMetric>();
            }
            this.metrics.add(value);
            return this;
        }

        public Builder metrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.metrics(fn.apply(new FieldMetric.Builder()).build());
        }

        public Builder addMetrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.addMetrics(fn.apply(new FieldMetric.Builder()).build());
        }

        public Builder pageSize(@Nullable Long value) {
            this.pageSize = value;
            return this;
        }

        public Builder rollupIndex(@Nullable String value) {
            this.rollupIndex = value;
            return this;
        }

        @Override
        public PutJobRequest build() {
            return new PutJobRequest(this);
        }
    }
}

