/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RealmInfo;
import co.elastic.clients.elasticsearch.security.authenticate.Token;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AuthenticateResponse
implements JsonpSerializable {
    private final RealmInfo authenticationRealm;
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    private final RealmInfo lookupRealm;
    private final Map<String, JsonData> metadata;
    private final List<String> roles;
    private final String username;
    private final boolean enabled;
    private final String authenticationType;
    @Nullable
    private final Token token;
    public static final JsonpDeserializer<AuthenticateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuthenticateResponse::setupAuthenticateResponseDeserializer, Builder::build);

    public AuthenticateResponse(Builder builder) {
        this.authenticationRealm = Objects.requireNonNull(builder.authenticationRealm, "authentication_realm");
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.lookupRealm = Objects.requireNonNull(builder.lookupRealm, "lookup_realm");
        this.metadata = ModelTypeHelper.unmodifiableNonNull(builder.metadata, "metadata");
        this.roles = ModelTypeHelper.unmodifiableNonNull(builder.roles, "roles");
        this.username = Objects.requireNonNull(builder.username, "username");
        this.enabled = Objects.requireNonNull(builder.enabled, "enabled");
        this.authenticationType = Objects.requireNonNull(builder.authenticationType, "authentication_type");
        this.token = builder.token;
    }

    public AuthenticateResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public RealmInfo authenticationRealm() {
        return this.authenticationRealm;
    }

    @Nullable
    public String email() {
        return this.email;
    }

    @Nullable
    public String fullName() {
        return this.fullName;
    }

    public RealmInfo lookupRealm() {
        return this.lookupRealm;
    }

    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public List<String> roles() {
        return this.roles;
    }

    public String username() {
        return this.username;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    @Nullable
    public Token token() {
        return this.token;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("authentication_realm");
        this.authenticationRealm.serialize(generator, mapper);
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        generator.writeKey("lookup_realm");
        this.lookupRealm.serialize(generator, mapper);
        generator.writeKey("metadata");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("roles");
        generator.writeStartArray();
        for (String string : this.roles) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("authentication_type");
        generator.write(this.authenticationType);
        if (this.token != null) {
            generator.writeKey("token");
            this.token.serialize(generator, mapper);
        }
    }

    protected static void setupAuthenticateResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::authenticationRealm, RealmInfo._DESERIALIZER, "authentication_realm", new String[0]);
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email", new String[0]);
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name", new String[0]);
        op.add(Builder::lookupRealm, RealmInfo._DESERIALIZER, "lookup_realm", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::authenticationType, JsonpDeserializer.stringDeserializer(), "authentication_type", new String[0]);
        op.add(Builder::token, Token._DESERIALIZER, "token", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AuthenticateResponse> {
        private RealmInfo authenticationRealm;
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        private RealmInfo lookupRealm;
        private Map<String, JsonData> metadata;
        private List<String> roles;
        private String username;
        private Boolean enabled;
        private String authenticationType;
        @Nullable
        private Token token;

        public Builder authenticationRealm(RealmInfo value) {
            this.authenticationRealm = value;
            return this;
        }

        public Builder authenticationRealm(Function<RealmInfo.Builder, ObjectBuilder<RealmInfo>> fn) {
            return this.authenticationRealm(fn.apply(new RealmInfo.Builder()).build());
        }

        public Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public Builder lookupRealm(RealmInfo value) {
            this.lookupRealm = value;
            return this;
        }

        public Builder lookupRealm(Function<RealmInfo.Builder, ObjectBuilder<RealmInfo>> fn) {
            return this.lookupRealm(fn.apply(new RealmInfo.Builder()).build());
        }

        public Builder metadata(Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder roles(List<String> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder authenticationType(String value) {
            this.authenticationType = value;
            return this;
        }

        public Builder token(@Nullable Token value) {
            this.token = value;
            return this;
        }

        public Builder token(Function<Token.Builder, ObjectBuilder<Token>> fn) {
            return this.token(fn.apply(new Token.Builder()).build());
        }

        @Override
        public AuthenticateResponse build() {
            return new AuthenticateResponse(this);
        }
    }
}

