/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClearCachedServiceTokensResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ClearCachedServiceTokensRequest
extends RequestBase {
    private final String namespace;
    private final String service;
    private final List<String> name;
    public static final Endpoint<ClearCachedServiceTokensRequest, ClearCachedServiceTokensResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClearCachedServiceTokensRequest, ClearCachedServiceTokensResponse>(request -> "POST", request -> {
        boolean _namespace = true;
        int _service = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_clear_cache");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, ClearCachedServiceTokensResponse._DESERIALIZER);

    public ClearCachedServiceTokensRequest(Builder builder) {
        this.namespace = Objects.requireNonNull(builder.namespace, "namespace");
        this.service = Objects.requireNonNull(builder.service, "service");
        this.name = ModelTypeHelper.unmodifiableNonNull(builder.name, "name");
    }

    public ClearCachedServiceTokensRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String namespace() {
        return this.namespace;
    }

    public String service() {
        return this.service;
    }

    public List<String> name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<ClearCachedServiceTokensRequest> {
        private String namespace;
        private String service;
        private List<String> name;

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder service(String value) {
            this.service = value;
            return this;
        }

        public Builder name(List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        @Override
        public ClearCachedServiceTokensRequest build() {
            return new ClearCachedServiceTokensRequest(this);
        }
    }
}

