/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeletePrivilegesResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeletePrivilegesRequest
extends RequestBase {
    private final String application;
    private final String name;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<DeletePrivilegesRequest, DeletePrivilegesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeletePrivilegesRequest, DeletePrivilegesResponse>(request -> "DELETE", request -> {
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeletePrivilegesResponse._DESERIALIZER);

    public DeletePrivilegesRequest(Builder builder) {
        this.application = Objects.requireNonNull(builder.application, "application");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
    }

    public DeletePrivilegesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String application() {
        return this.application;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<DeletePrivilegesRequest> {
        private String application;
        private String name;
        @Nullable
        private JsonValue refresh;

        public Builder application(String value) {
            this.application = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeletePrivilegesRequest build() {
            return new DeletePrivilegesRequest(this);
        }
    }
}

