/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeleteRoleMappingResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteRoleMappingRequest
extends RequestBase {
    private final String name;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<DeleteRoleMappingRequest, DeleteRoleMappingResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteRoleMappingRequest, DeleteRoleMappingResponse>(request -> "DELETE", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteRoleMappingResponse._DESERIALIZER);

    public DeleteRoleMappingRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
    }

    public DeleteRoleMappingRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<DeleteRoleMappingRequest> {
        private String name;
        @Nullable
        private JsonValue refresh;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeleteRoleMappingRequest build() {
            return new DeleteRoleMappingRequest(this);
        }
    }
}

