/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeleteServiceTokenResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteServiceTokenRequest
extends RequestBase {
    private final String namespace;
    private final String service;
    private final String name;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<DeleteServiceTokenRequest, DeleteServiceTokenResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteServiceTokenRequest, DeleteServiceTokenResponse>(request -> "DELETE", request -> {
        boolean _namespace = true;
        int _service = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteServiceTokenResponse._DESERIALIZER);

    public DeleteServiceTokenRequest(Builder builder) {
        this.namespace = Objects.requireNonNull(builder.namespace, "namespace");
        this.service = Objects.requireNonNull(builder.service, "service");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
    }

    public DeleteServiceTokenRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String namespace() {
        return this.namespace;
    }

    public String service() {
        return this.service;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<DeleteServiceTokenRequest> {
        private String namespace;
        private String service;
        private String name;
        @Nullable
        private JsonValue refresh;

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder service(String value) {
            this.service = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeleteServiceTokenRequest build() {
            return new DeleteServiceTokenRequest(this);
        }
    }
}

