/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetPrivilegesResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetPrivilegesRequest
extends RequestBase {
    @Nullable
    private final String application;
    @Nullable
    private final String name;
    public static final Endpoint<GetPrivilegesRequest, GetPrivilegesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetPrivilegesRequest, GetPrivilegesResponse>(request -> "GET", request -> {
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        if (request.application() != null) {
            propsSet |= 1;
        }
        if (request.name() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetPrivilegesResponse._DESERIALIZER);

    public GetPrivilegesRequest(Builder builder) {
        this.application = builder.application;
        this.name = builder.name;
    }

    public GetPrivilegesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String application() {
        return this.application;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<GetPrivilegesRequest> {
        @Nullable
        private String application;
        @Nullable
        private String name;

        public Builder application(@Nullable String value) {
            this.application = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public GetPrivilegesRequest build() {
            return new GetPrivilegesRequest(this);
        }
    }
}

