/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetUserResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetUserRequest
extends RequestBase {
    @Nullable
    private final List<String> username;
    public static final Endpoint<GetUserRequest, GetUserResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetUserRequest, GetUserResponse>(request -> "GET", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (request.username() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetUserResponse._DESERIALIZER);

    public GetUserRequest(Builder builder) {
        this.username = ModelTypeHelper.unmodifiable(builder.username);
    }

    public GetUserRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> username() {
        return this.username;
    }

    public static class Builder
    implements ObjectBuilder<GetUserRequest> {
        @Nullable
        private List<String> username;

        public Builder username(@Nullable List<String> value) {
            this.username = value;
            return this;
        }

        public Builder username(String ... value) {
            this.username = Arrays.asList(value);
            return this;
        }

        public Builder addUsername(String value) {
            if (this.username == null) {
                this.username = new ArrayList<String>();
            }
            this.username.add(value);
            return this;
        }

        @Override
        public GetUserRequest build() {
            return new GetUserRequest(this);
        }
    }
}

