/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HasPrivilegesResponse
implements JsonpSerializable {
    private final Map<String, Map<String, Map<String, Boolean>>> application;
    private final Map<String, Boolean> cluster;
    private final boolean hasAllRequested;
    private final Map<String, Map<String, Boolean>> index;
    private final String username;
    public static final JsonpDeserializer<HasPrivilegesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasPrivilegesResponse::setupHasPrivilegesResponseDeserializer, Builder::build);

    public HasPrivilegesResponse(Builder builder) {
        this.application = ModelTypeHelper.unmodifiableNonNull(builder.application, "application");
        this.cluster = ModelTypeHelper.unmodifiableNonNull(builder.cluster, "cluster");
        this.hasAllRequested = Objects.requireNonNull(builder.hasAllRequested, "has_all_requested");
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.username = Objects.requireNonNull(builder.username, "username");
    }

    public HasPrivilegesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Map<String, Map<String, Boolean>>> application() {
        return this.application;
    }

    public Map<String, Boolean> cluster() {
        return this.cluster;
    }

    public boolean hasAllRequested() {
        return this.hasAllRequested;
    }

    public Map<String, Map<String, Boolean>> index() {
        return this.index;
    }

    public String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("application");
        generator.writeStartObject();
        for (Map.Entry<String, Map<String, Map<String, Boolean>>> entry : this.application.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, Boolean>> entry2 : entry.getValue().entrySet()) {
                generator.writeKey(entry2.getKey());
                generator.writeStartObject();
                for (Map.Entry<String, Boolean> item2 : entry2.getValue().entrySet()) {
                    generator.writeKey(item2.getKey());
                    generator.write(item2.getValue().booleanValue());
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("cluster");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.cluster.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(((Boolean)entry.getValue()).booleanValue());
        }
        generator.writeEnd();
        generator.writeKey("has_all_requested");
        generator.write(this.hasAllRequested);
        generator.writeKey("index");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.index.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, Boolean>> entry3 : ((Map)entry.getValue()).entrySet()) {
                generator.writeKey(entry3.getKey());
                generator.write(((Boolean)((Object)entry3.getValue())).booleanValue());
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("username");
        generator.write(this.username);
    }

    protected static void setupHasPrivilegesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()))), "application", new String[0]);
        op.add(Builder::cluster, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "cluster", new String[0]);
        op.add(Builder::hasAllRequested, JsonpDeserializer.booleanDeserializer(), "has_all_requested", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer())), "index", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HasPrivilegesResponse> {
        private Map<String, Map<String, Map<String, Boolean>>> application;
        private Map<String, Boolean> cluster;
        private Boolean hasAllRequested;
        private Map<String, Map<String, Boolean>> index;
        private String username;

        public Builder application(Map<String, Map<String, Map<String, Boolean>>> value) {
            this.application = value;
            return this;
        }

        public Builder putApplication(String key, Map<String, Map<String, Boolean>> value) {
            if (this.application == null) {
                this.application = new HashMap<String, Map<String, Map<String, Boolean>>>();
            }
            this.application.put(key, value);
            return this;
        }

        public Builder cluster(Map<String, Boolean> value) {
            this.cluster = value;
            return this;
        }

        public Builder putCluster(String key, Boolean value) {
            if (this.cluster == null) {
                this.cluster = new HashMap<String, Boolean>();
            }
            this.cluster.put(key, value);
            return this;
        }

        public Builder hasAllRequested(boolean value) {
            this.hasAllRequested = value;
            return this;
        }

        public Builder index(Map<String, Map<String, Boolean>> value) {
            this.index = value;
            return this;
        }

        public Builder putIndex(String key, Map<String, Boolean> value) {
            if (this.index == null) {
                this.index = new HashMap<String, Map<String, Boolean>>();
            }
            this.index.put(key, value);
            return this;
        }

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        public HasPrivilegesResponse build() {
            return new HasPrivilegesResponse(this);
        }
    }
}

