/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_api_key;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ApiKey
implements JsonpSerializable {
    private final long creation;
    @Nullable
    private final Long expiration;
    private final String id;
    private final boolean invalidated;
    private final String name;
    private final String realm;
    private final String username;
    @Nullable
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<ApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKey::setupApiKeyDeserializer, Builder::build);

    public ApiKey(Builder builder) {
        this.creation = Objects.requireNonNull(builder.creation, "creation");
        this.expiration = builder.expiration;
        this.id = Objects.requireNonNull(builder.id, "id");
        this.invalidated = Objects.requireNonNull(builder.invalidated, "invalidated");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.realm = Objects.requireNonNull(builder.realm, "realm");
        this.username = Objects.requireNonNull(builder.username, "username");
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
    }

    public ApiKey(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long creation() {
        return this.creation;
    }

    @Nullable
    public Long expiration() {
        return this.expiration;
    }

    public String id() {
        return this.id;
    }

    public boolean invalidated() {
        return this.invalidated;
    }

    public String name() {
        return this.name;
    }

    public String realm() {
        return this.realm;
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("creation");
        generator.write(this.creation);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration.longValue());
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("invalidated");
        generator.write(this.invalidated);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("realm");
        generator.write(this.realm);
        generator.writeKey("username");
        generator.write(this.username);
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupApiKeyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::creation, JsonpDeserializer.longDeserializer(), "creation", new String[0]);
        op.add(Builder::expiration, JsonpDeserializer.longDeserializer(), "expiration", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::invalidated, JsonpDeserializer.booleanDeserializer(), "invalidated", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ApiKey> {
        private Long creation;
        @Nullable
        private Long expiration;
        private String id;
        private Boolean invalidated;
        private String name;
        private String realm;
        private String username;
        @Nullable
        private Map<String, JsonData> metadata;

        public Builder creation(long value) {
            this.creation = value;
            return this;
        }

        public Builder expiration(@Nullable Long value) {
            this.expiration = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder invalidated(boolean value) {
            this.invalidated = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder realm(String value) {
            this.realm = value;
            return this;
        }

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public ApiKey build() {
            return new ApiKey(this);
        }
    }
}

