/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.GetRepositoryResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetRepositoryRequest
extends RequestBase {
    @Nullable
    private final List<String> repository;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<GetRepositoryRequest, GetRepositoryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetRepositoryRequest, GetRepositoryResponse>(request -> "GET", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (request.repository() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetRepositoryResponse._DESERIALIZER);

    public GetRepositoryRequest(Builder builder) {
        this.repository = ModelTypeHelper.unmodifiable(builder.repository);
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public GetRepositoryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> repository() {
        return this.repository;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<GetRepositoryRequest> {
        @Nullable
        private List<String> repository;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;

        public Builder repository(@Nullable List<String> value) {
            this.repository = value;
            return this;
        }

        public Builder repository(String ... value) {
            this.repository = Arrays.asList(value);
            return this;
        }

        public Builder addRepository(String value) {
            if (this.repository == null) {
                this.repository = new ArrayList<String>();
            }
            this.repository.add(value);
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public GetRepositoryRequest build() {
            return new GetRepositoryRequest(this);
        }
    }
}

