/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.FileCountSnapshotStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SnapshotStats
implements JsonpSerializable {
    private final FileCountSnapshotStats incremental;
    private final long startTimeInMillis;
    private final long timeInMillis;
    private final FileCountSnapshotStats total;
    public static final JsonpDeserializer<SnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotStats::setupSnapshotStatsDeserializer, Builder::build);

    public SnapshotStats(Builder builder) {
        this.incremental = Objects.requireNonNull(builder.incremental, "incremental");
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.timeInMillis = Objects.requireNonNull(builder.timeInMillis, "time_in_millis");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public SnapshotStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public FileCountSnapshotStats incremental() {
        return this.incremental;
    }

    public long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public long timeInMillis() {
        return this.timeInMillis;
    }

    public FileCountSnapshotStats total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("incremental");
        this.incremental.serialize(generator, mapper);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupSnapshotStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::incremental, FileCountSnapshotStats._DESERIALIZER, "incremental", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis", new String[0]);
        op.add(Builder::total, FileCountSnapshotStats._DESERIALIZER, "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotStats> {
        private FileCountSnapshotStats incremental;
        private Long startTimeInMillis;
        private Long timeInMillis;
        private FileCountSnapshotStats total;

        public Builder incremental(FileCountSnapshotStats value) {
            this.incremental = value;
            return this;
        }

        public Builder incremental(Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
            return this.incremental(fn.apply(new FileCountSnapshotStats.Builder()).build());
        }

        public Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public Builder total(FileCountSnapshotStats value) {
            this.total = value;
            return this;
        }

        public Builder total(Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
            return this.total(fn.apply(new FileCountSnapshotStats.Builder()).build());
        }

        @Override
        public SnapshotStats build() {
            return new SnapshotStats(this);
        }
    }
}

