/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.VerifyRepositoryResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class VerifyRepositoryRequest
extends RequestBase {
    private final String repository;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<VerifyRepositoryRequest, VerifyRepositoryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<VerifyRepositoryRequest, VerifyRepositoryResponse>(request -> "POST", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/_verify");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, VerifyRepositoryResponse._DESERIALIZER);

    public VerifyRepositoryRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public VerifyRepositoryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<VerifyRepositoryRequest> {
        private String repository;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public VerifyRepositoryRequest build() {
            return new VerifyRepositoryRequest(this);
        }
    }
}

