/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.transform.PreviewTransformRequest;
import co.elastic.clients.elasticsearch.transform.PutTransformResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutTransformRequest
extends PreviewTransformRequest {
    private final String transformId;
    @Nullable
    private final Boolean deferValidation;
    public static final JsonpDeserializer<PutTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTransformRequest::setupPutTransformRequestDeserializer, Builder::build);
    public static final Endpoint<PutTransformRequest, PutTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutTransformRequest, PutTransformResponse>(request -> "PUT", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deferValidation != null) {
            params.put("defer_validation", String.valueOf(request.deferValidation));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTransformResponse._DESERIALIZER);

    public PutTransformRequest(AbstractBuilder<?> builder) {
        super(builder);
        this.transformId = Objects.requireNonNull(((AbstractBuilder)builder).transformId, "transform_id");
        this.deferValidation = ((AbstractBuilder)builder).deferValidation;
    }

    @Override
    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Boolean deferValidation() {
        return this.deferValidation;
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPutTransformRequestDeserializer(DelegatingDeserializer<BuilderT> op) {
        PreviewTransformRequest.setupPreviewTransformRequestDeserializer(op);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends PreviewTransformRequest.AbstractBuilder<BuilderT> {
        private String transformId;
        @Nullable
        private Boolean deferValidation;

        protected AbstractBuilder() {
        }

        @Override
        public BuilderT transformId(String value) {
            this.transformId = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT deferValidation(@Nullable Boolean value) {
            this.deferValidation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<PutTransformRequest> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTransformRequest build() {
            return new PutTransformRequest(this);
        }
    }
}

