/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.elasticsearch.transform.TimeRetentionPolicy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class RetentionPolicy
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String TIME = "time";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<RetentionPolicy> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, RetentionPolicy::setupRetentionPolicyDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public RetentionPolicy(RetentionPolicyVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private RetentionPolicy(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public RetentionPolicy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public TimeRetentionPolicy time() {
        return (TimeRetentionPolicy)TaggedUnionUtils.get(this, TIME);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRetentionPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::time, TimeRetentionPolicy._DESERIALIZER, TIME, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RetentionPolicy> {
        private String _type;
        private Object _value;

        public Builder time(TimeRetentionPolicy v) {
            this._type = RetentionPolicy.TIME;
            this._value = v;
            return this;
        }

        public Builder time(Function<TimeRetentionPolicy.Builder, ObjectBuilder<TimeRetentionPolicy>> f) {
            return this.time(f.apply(new TimeRetentionPolicy.Builder()).build());
        }

        @Override
        public RetentionPolicy build() {
            return new RetentionPolicy(this);
        }
    }
}

