/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch._types.NodeAttributes;
import co.elastic.clients.elasticsearch.transform.get_transform_stats.Checkpointing;
import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformIndexerStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TransformStats
implements JsonpSerializable {
    private final Checkpointing checkpointing;
    private final String id;
    @Nullable
    private final NodeAttributes node;
    @Nullable
    private final String reason;
    private final String state;
    private final TransformIndexerStats stats;
    public static final JsonpDeserializer<TransformStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformStats::setupTransformStatsDeserializer, Builder::build);

    public TransformStats(Builder builder) {
        this.checkpointing = Objects.requireNonNull(builder.checkpointing, "checkpointing");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.node = builder.node;
        this.reason = builder.reason;
        this.state = Objects.requireNonNull(builder.state, "state");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
    }

    public TransformStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Checkpointing checkpointing() {
        return this.checkpointing;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public NodeAttributes node() {
        return this.node;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public String state() {
        return this.state;
    }

    public TransformIndexerStats stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("checkpointing");
        this.checkpointing.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupTransformStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::checkpointing, Checkpointing._DESERIALIZER, "checkpointing", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::node, NodeAttributes._DESERIALIZER, "node", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", new String[0]);
        op.add(Builder::stats, TransformIndexerStats._DESERIALIZER, "stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TransformStats> {
        private Checkpointing checkpointing;
        private String id;
        @Nullable
        private NodeAttributes node;
        @Nullable
        private String reason;
        private String state;
        private TransformIndexerStats stats;

        public Builder checkpointing(Checkpointing value) {
            this.checkpointing = value;
            return this;
        }

        public Builder checkpointing(Function<Checkpointing.Builder, ObjectBuilder<Checkpointing>> fn) {
            return this.checkpointing(fn.apply(new Checkpointing.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder node(@Nullable NodeAttributes value) {
            this.node = value;
            return this;
        }

        public Builder node(Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.node(fn.apply(new NodeAttributes.Builder()).build());
        }

        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public Builder state(String value) {
            this.state = value;
            return this;
        }

        public Builder stats(TransformIndexerStats value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<TransformIndexerStats.Builder, ObjectBuilder<TransformIndexerStats>> fn) {
            return this.stats(fn.apply(new TransformIndexerStats.Builder()).build());
        }

        @Override
        public TransformStats build() {
            return new TransformStats(this);
        }
    }
}

