/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExecutionState
implements JsonpSerializable {
    private final boolean successful;
    private final String timestamp;
    public static final JsonpDeserializer<ExecutionState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionState::setupExecutionStateDeserializer, Builder::build);

    public ExecutionState(Builder builder) {
        this.successful = Objects.requireNonNull(builder.successful, "successful");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public ExecutionState(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean successful() {
        return this.successful;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("successful");
        generator.write(this.successful);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupExecutionStateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::successful, JsonpDeserializer.booleanDeserializer(), "successful", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutionState> {
        private Boolean successful;
        private String timestamp;

        public Builder successful(boolean value) {
            this.successful = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public ExecutionState build() {
            return new ExecutionState(this);
        }
    }
}

