/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.HttpInputRequestDefinition;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.ResponseContentType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HttpInput
implements InputVariant,
JsonpSerializable {
    @Nullable
    private final HttpInput http;
    @Nullable
    private final List<String> extract;
    @Nullable
    private final HttpInputRequestDefinition request;
    @Nullable
    private final ResponseContentType responseContentType;
    public static final JsonpDeserializer<HttpInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInput::setupHttpInputDeserializer, Builder::build);

    public HttpInput(Builder builder) {
        this.http = builder.http;
        this.extract = ModelTypeHelper.unmodifiable(builder.extract);
        this.request = builder.request;
        this.responseContentType = builder.responseContentType;
    }

    public HttpInput(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "http";
    }

    @Nullable
    public HttpInput http() {
        return this.http;
    }

    @Nullable
    public List<String> extract() {
        return this.extract;
    }

    @Nullable
    public HttpInputRequestDefinition request() {
        return this.request;
    }

    @Nullable
    public ResponseContentType responseContentType() {
        return this.responseContentType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (this.extract != null) {
            generator.writeKey("extract");
            generator.writeStartArray();
            for (String item0 : this.extract) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (this.responseContentType != null) {
            generator.writeKey("response_content_type");
            this.responseContentType.serialize(generator, mapper);
        }
    }

    protected static void setupHttpInputDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::http, _DESERIALIZER, "http", new String[0]);
        op.add(Builder::extract, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extract", new String[0]);
        op.add(Builder::request, HttpInputRequestDefinition._DESERIALIZER, "request", new String[0]);
        op.add(Builder::responseContentType, ResponseContentType._DESERIALIZER, "response_content_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HttpInput> {
        @Nullable
        private HttpInput http;
        @Nullable
        private List<String> extract;
        @Nullable
        private HttpInputRequestDefinition request;
        @Nullable
        private ResponseContentType responseContentType;

        public Builder http(@Nullable HttpInput value) {
            this.http = value;
            return this;
        }

        public Builder http(Function<Builder, ObjectBuilder<HttpInput>> fn) {
            return this.http(fn.apply(new Builder()).build());
        }

        public Builder extract(@Nullable List<String> value) {
            this.extract = value;
            return this;
        }

        public Builder extract(String ... value) {
            this.extract = Arrays.asList(value);
            return this;
        }

        public Builder addExtract(String value) {
            if (this.extract == null) {
                this.extract = new ArrayList<String>();
            }
            this.extract.add(value);
            return this;
        }

        public Builder request(@Nullable HttpInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public Builder request(Function<HttpInputRequestDefinition.Builder, ObjectBuilder<HttpInputRequestDefinition>> fn) {
            return this.request(fn.apply(new HttpInputRequestDefinition.Builder()).build());
        }

        public Builder responseContentType(@Nullable ResponseContentType value) {
            this.responseContentType = value;
            return this;
        }

        @Override
        public HttpInput build() {
            return new HttpInput(this);
        }
    }
}

