/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Index
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String docId;
    @Nullable
    private final JsonValue refresh;
    public static final JsonpDeserializer<Index> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Index::setupIndexDeserializer, Builder::build);

    public Index(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.docId = builder.docId;
        this.refresh = builder.refresh;
    }

    public Index(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String docId() {
        return this.docId;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.docId != null) {
            generator.writeKey("doc_id");
            generator.write(this.docId);
        }
        if (this.refresh != null) {
            generator.writeKey("refresh");
            generator.write(this.refresh);
        }
    }

    protected static void setupIndexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::docId, JsonpDeserializer.stringDeserializer(), "doc_id", new String[0]);
        op.add(Builder::refresh, JsonpDeserializer.jsonValueDeserializer(), "refresh", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Index> {
        private String index;
        @Nullable
        private String docId;
        @Nullable
        private JsonValue refresh;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder docId(@Nullable String value) {
            this.docId = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public Index build() {
            return new Index(this);
        }
    }
}

