/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ChainInput;
import co.elastic.clients.elasticsearch.watcher.HttpInput;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInput;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Input
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String CHAIN = "chain";
    public static final String HTTP = "http";
    public static final String SEARCH = "search";
    public static final String SIMPLE = "simple";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Input> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Input::setupInputDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Input(InputVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Input(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Input(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ChainInput chain() {
        return (ChainInput)TaggedUnionUtils.get(this, CHAIN);
    }

    public HttpInput http() {
        return (HttpInput)TaggedUnionUtils.get(this, HTTP);
    }

    public SearchInput search() {
        return (SearchInput)TaggedUnionUtils.get(this, SEARCH);
    }

    public Map<String, JsonData> simple() {
        return (Map)TaggedUnionUtils.get(this, SIMPLE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "simple": {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        ((JsonData)item0.getValue()).serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupInputDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::chain, ChainInput._DESERIALIZER, CHAIN, new String[0]);
        op.add(Builder::http, HttpInput._DESERIALIZER, HTTP, new String[0]);
        op.add(Builder::search, SearchInput._DESERIALIZER, SEARCH, new String[0]);
        op.add(Builder::simple, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), SIMPLE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Input> {
        private String _type;
        private Object _value;

        public Builder chain(ChainInput v) {
            this._type = Input.CHAIN;
            this._value = v;
            return this;
        }

        public Builder chain(Function<ChainInput.Builder, ObjectBuilder<ChainInput>> f) {
            return this.chain(f.apply(new ChainInput.Builder()).build());
        }

        public Builder http(HttpInput v) {
            this._type = Input.HTTP;
            this._value = v;
            return this;
        }

        public Builder http(Function<HttpInput.Builder, ObjectBuilder<HttpInput>> f) {
            return this.http(f.apply(new HttpInput.Builder()).build());
        }

        public Builder search(SearchInput v) {
            this._type = Input.SEARCH;
            this._value = v;
            return this;
        }

        public Builder search(Function<SearchInput.Builder, ObjectBuilder<SearchInput>> f) {
            return this.search(f.apply(new SearchInput.Builder()).build());
        }

        public Builder simple(Map<String, JsonData> v) {
            this._type = Input.SIMPLE;
            this._value = v;
            return this;
        }

        @Override
        public Input build() {
            return new Input(this);
        }
    }
}

