/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Schedule;
import co.elastic.clients.elasticsearch.watcher.TriggerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Trigger
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String SCHEDULE = "schedule";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Trigger> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Trigger::setupTriggerDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Trigger(TriggerVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Trigger(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Trigger(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Schedule schedule() {
        return (Schedule)TaggedUnionUtils.get(this, SCHEDULE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTriggerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::schedule, Schedule._DESERIALIZER, SCHEDULE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Trigger> {
        private String _type;
        private Object _value;

        public Builder schedule(Schedule v) {
            this._type = Trigger.SCHEDULE;
            this._value = v;
            return this;
        }

        public Builder schedule(Function<Schedule.Builder, ObjectBuilder<Schedule>> f) {
            return this.schedule(f.apply(new Schedule.Builder()).build());
        }

        @Override
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

