package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:业务单据数据的日志记录操作 </dd>
 * <dd>@date: 2020/08/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@TableName(value = "merchant_goods_stock_business_log")
public class MerchantGoodsStockBusinessLog  extends UserTimeEntity {

    private static final long serialVersionUID = 1L;
    /**
     *  业务系统的 订单编号 获取 其他的单据类型号
     */
    public String docNo;

    /**
     * 子单据号，也就是子订单编号
     */
    public String subDocNo;
    /**
     * 单据的类型：订单，....
     */
    public String docType;
    /**
     * 商品编码
     */
    public String goodsCode;

    /**
     *
     * 占用库存数量
     */
    public Integer occupiedNum;

    /**
     * 已出库数量
     */
    public Integer outNum;

    /**
     *取消数量，目前只有订单超时/用户主动取消的，全部取消不支持部分
     */
    public Integer cancelNum;

    /**
     * 占用库存时间
     */
    public LocalDateTime occupiedTime;

    /**
     * 出库时间
     */
    public LocalDateTime outTime;

    /**
     * 取消时间
     */
    public LocalDateTime cancelTime;

    /**
     * 关联的SKU编码
     */
    private String relateGoodsCode;

    /**
     * 商品购买数量
     */
    private Integer buyNum;

    /**
     * 1个套餐，商品项组成数量,为了计算占用库存用
     */
    private Integer scaleNum;

    /**
     * 关联商品是否出库,情况福袋子项(A,B)都出库了，需要更新库福袋主SKU为已出库。
     * 为了防止两个线程同时到达更新A,B后，都要进行出库。
     */
    private Boolean relateGoodsOut;



}
