/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.DataStoreReference;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.MessageFlow;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.util.JsonConverterUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnJsonConverter
implements EditorJsonConstants,
StencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnJsonConverter.class);
    public static final String NAMESPACE = "http://activiti.com/modeler";
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ActivityProcessor processor;
    protected BpmnModel model;
    protected ObjectNode flowElementNode;
    protected double subProcessX;
    protected double subProcessY;
    protected ArrayNode shapesArrayNode;

    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        ServiceTask serviceTask;
        this.model = model;
        this.processor = processor;
        this.subProcessX = subProcessX;
        this.subProcessY = subProcessY;
        this.shapesArrayNode = shapesArrayNode;
        GraphicInfo graphicInfo = model.getGraphicInfo(baseElement.getId());
        String stencilId = null;
        stencilId = baseElement instanceof ServiceTask ? ("mail".equalsIgnoreCase((serviceTask = (ServiceTask)baseElement).getType()) ? "MailTask" : ("camel".equalsIgnoreCase(serviceTask.getType()) ? "CamelTask" : ("mule".equalsIgnoreCase(serviceTask.getType()) ? "MuleTask" : this.getStencilId(baseElement)))) : this.getStencilId(baseElement);
        this.flowElementNode = BpmnJsonConverterUtil.createChildShape(baseElement.getId(), stencilId, graphicInfo.getX() - subProcessX + graphicInfo.getWidth(), graphicInfo.getY() - subProcessY + graphicInfo.getHeight(), graphicInfo.getX() - subProcessX, graphicInfo.getY() - subProcessY);
        shapesArrayNode.add((JsonNode)this.flowElementNode);
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", baseElement.getId());
        if (baseElement instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)baseElement;
            if (StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
                propertiesNode.put("name", flowElement.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)flowElement.getDocumentation())) {
                propertiesNode.put("documentation", flowElement.getDocumentation());
            }
        }
        this.convertElementToJson(propertiesNode, baseElement);
        this.flowElementNode.put("properties", (JsonNode)propertiesNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        if (baseElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseElement;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getId()));
            }
            for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                if (!messageFlow.getSourceRef().equals(flowNode.getId())) continue;
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getId()));
            }
        }
        if (baseElement instanceof Activity) {
            MultiInstanceLoopCharacteristics loopDef;
            Activity activity = (Activity)baseElement;
            for (BoundaryEvent boundaryEvent : activity.getBoundaryEvents()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(boundaryEvent.getId()));
            }
            propertiesNode.put("asynchronousdefinition", activity.isAsynchronous());
            propertiesNode.put("exclusivedefinition", !activity.isNotExclusive());
            if (activity.getLoopCharacteristics() != null && (StringUtils.isNotEmpty((CharSequence)(loopDef = activity.getLoopCharacteristics()).getLoopCardinality()) || StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem()) || StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition()))) {
                if (!loopDef.isSequential()) {
                    propertiesNode.put("multiinstance_type", "Parallel");
                } else {
                    propertiesNode.put("multiinstance_type", "Sequential");
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getLoopCardinality())) {
                    propertiesNode.put("multiinstance_cardinality", loopDef.getLoopCardinality());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getInputDataItem())) {
                    propertiesNode.put("multiinstance_collection", loopDef.getInputDataItem());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getElementVariable())) {
                    propertiesNode.put("multiinstance_variable", loopDef.getElementVariable());
                }
                if (StringUtils.isNotEmpty((CharSequence)loopDef.getCompletionCondition())) {
                    propertiesNode.put("multiinstance_condition", loopDef.getCompletionCondition());
                }
            }
            if (activity instanceof UserTask) {
                BpmnJsonConverterUtil.convertListenersToJson(((UserTask)activity).getTaskListeners(), false, propertiesNode);
            }
            BpmnJsonConverterUtil.convertListenersToJson(activity.getExecutionListeners(), true, propertiesNode);
            if (CollectionUtils.isNotEmpty((Collection)activity.getDataInputAssociations())) {
                for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                    if (model.getFlowElement(dataAssociation.getSourceRef()) == null) continue;
                    this.createDataAssociation(dataAssociation, true, activity);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)activity.getDataOutputAssociations())) {
                for (DataAssociation dataAssociation : activity.getDataOutputAssociations()) {
                    if (model.getFlowElement(dataAssociation.getTargetRef()) == null) continue;
                    this.createDataAssociation(dataAssociation, false, activity);
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(dataAssociation.getId()));
                }
            }
        }
        for (Artifact artifact : container.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || !StringUtils.isNotEmpty((CharSequence)(association = (Association)artifact).getSourceRef()) || !association.getSourceRef().equals(baseElement.getId())) continue;
            outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(association.getId()));
        }
        if (baseElement instanceof DataStoreReference) {
            for (Process process : model.getProcesses()) {
                this.processDataStoreReferences((FlowElementsContainer)process, baseElement.getId(), outgoingArrayNode);
            }
        }
        this.flowElementNode.put("outgoing", (JsonNode)outgoingArrayNode);
    }

    protected void processDataStoreReferences(FlowElementsContainer container, String dataStoreReferenceId, ArrayNode outgoingArrayNode) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (flowElement instanceof Activity) {
                Activity activity = (Activity)flowElement;
                if (!CollectionUtils.isNotEmpty((Collection)activity.getDataInputAssociations())) continue;
                for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                    if (!dataStoreReferenceId.equals(dataAssociation.getSourceRef())) continue;
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(dataAssociation.getId()));
                }
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            this.processDataStoreReferences((FlowElementsContainer)((SubProcess)flowElement), dataStoreReferenceId, outgoingArrayNode);
        }
    }

    protected void createDataAssociation(DataAssociation dataAssociation, boolean incoming, Activity activity) {
        String sourceRef = null;
        String targetRef = null;
        if (incoming) {
            sourceRef = dataAssociation.getSourceRef();
            targetRef = activity.getId();
        } else {
            sourceRef = activity.getId();
            targetRef = dataAssociation.getTargetRef();
        }
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(dataAssociation.getId(), "DataAssociation", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", this.model.getGraphicInfo(sourceRef).getWidth() / 2.0);
        dockNode.put("y", this.model.getGraphicInfo(sourceRef).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).size() > 2) {
            for (int i = 1; i < this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)this.model.getFlowLocationGraphicInfo(dataAssociation.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", this.model.getGraphicInfo(targetRef).getWidth() / 2.0);
        dockNode.put("y", this.model.getGraphicInfo(targetRef).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.put("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(targetRef));
        flowNode.put("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.put("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(targetRef));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", dataAssociation.getId());
        flowNode.put("properties", (JsonNode)propertiesNode);
        this.shapesArrayNode.add((JsonNode)flowNode);
    }

    public void convertToBpmnModel(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnModel bpmnModel) {
        Lane lane;
        FlowElement flowElement;
        this.processor = processor;
        this.model = bpmnModel;
        BaseElement baseElement = this.convertJsonToElement(elementNode, modelNode, shapeMap);
        baseElement.setId(BpmnJsonConverterUtil.getElementId(elementNode));
        if (baseElement instanceof FlowElement) {
            JsonNode orderArray;
            JsonNode flowOrderNode;
            flowElement = (FlowElement)baseElement;
            flowElement.setName(this.getPropertyValueAsString("name", elementNode));
            flowElement.setDocumentation(this.getPropertyValueAsString("documentation", elementNode));
            BpmnJsonConverterUtil.convertJsonToListeners(elementNode, (BaseElement)flowElement);
            if (baseElement instanceof Activity) {
                Activity activity = (Activity)baseElement;
                activity.setAsynchronous(this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode));
                activity.setNotExclusive(!this.getPropertyValueAsBoolean("exclusivedefinition", elementNode));
                String multiInstanceType = this.getPropertyValueAsString("multiinstance_type", elementNode);
                String multiInstanceCardinality = this.getPropertyValueAsString("multiinstance_cardinality", elementNode);
                String multiInstanceCollection = this.getPropertyValueAsString("multiinstance_collection", elementNode);
                String multiInstanceCondition = this.getPropertyValueAsString("multiinstance_condition", elementNode);
                if (StringUtils.isNotEmpty((CharSequence)multiInstanceType) && !"none".equalsIgnoreCase(multiInstanceType)) {
                    String multiInstanceVariable = this.getPropertyValueAsString("multiinstance_variable", elementNode);
                    MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();
                    if ("sequential".equalsIgnoreCase(multiInstanceType)) {
                        multiInstanceObject.setSequential(true);
                    } else {
                        multiInstanceObject.setSequential(false);
                    }
                    multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
                    multiInstanceObject.setInputDataItem(multiInstanceCollection);
                    multiInstanceObject.setElementVariable(multiInstanceVariable);
                    multiInstanceObject.setCompletionCondition(multiInstanceCondition);
                    activity.setLoopCharacteristics(multiInstanceObject);
                }
            } else if (baseElement instanceof Gateway && (flowOrderNode = this.getProperty("sequencefloworder", elementNode)) != null && (orderArray = (flowOrderNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(flowOrderNode)).get("sequenceFlowOrder")) != null && orderArray.size() > 0) {
                for (JsonNode orderNode : orderArray) {
                    ExtensionElement orderElement = new ExtensionElement();
                    orderElement.setName("EDITOR_FLOW_ORDER");
                    orderElement.setElementText(orderNode.asText());
                    flowElement.addExtensionElement(orderElement);
                }
            }
        }
        if (baseElement instanceof FlowElement) {
            flowElement = (FlowElement)baseElement;
            if (flowElement instanceof SequenceFlow) {
                ExtensionElement idExtensionElement = new ExtensionElement();
                idExtensionElement.setName("EDITOR_RESOURCEID");
                idExtensionElement.setElementText(elementNode.get("resourceId").asText());
                flowElement.addExtensionElement(idExtensionElement);
            }
            if (parentElement instanceof Process) {
                ((Process)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(flowElement.getId());
                lane.getParentProcess().addFlowElement(flowElement);
            }
        } else if (baseElement instanceof Artifact) {
            Artifact artifact = (Artifact)baseElement;
            if (parentElement instanceof Process) {
                ((Process)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(artifact.getId());
                lane.getParentProcess().addArtifact(artifact);
            }
        }
    }

    protected abstract void convertElementToJson(ObjectNode var1, BaseElement var2);

    protected abstract BaseElement convertJsonToElement(JsonNode var1, JsonNode var2, Map<String, JsonNode> var3);

    protected abstract String getStencilId(BaseElement var1);

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }

    protected void addFormProperties(List<FormProperty> formProperties, ObjectNode propertiesNode) {
        if (CollectionUtils.isEmpty(formProperties)) {
            return;
        }
        ObjectNode formPropertiesNode = this.objectMapper.createObjectNode();
        ArrayNode propertiesArrayNode = this.objectMapper.createArrayNode();
        for (FormProperty property : formProperties) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("id", property.getId());
            propertyItemNode.put("name", property.getName());
            propertyItemNode.put("type", property.getType());
            if (StringUtils.isNotEmpty((CharSequence)property.getExpression())) {
                propertyItemNode.put("expression", property.getExpression());
            } else {
                propertyItemNode.putNull("expression");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getVariable())) {
                propertyItemNode.put("variable", property.getVariable());
            } else {
                propertyItemNode.putNull("variable");
            }
            if (StringUtils.isNotEmpty((CharSequence)property.getDatePattern())) {
                propertyItemNode.put("datePattern", property.getDatePattern());
            }
            if (CollectionUtils.isNotEmpty((Collection)property.getFormValues())) {
                ArrayNode valuesNode = this.objectMapper.createArrayNode();
                for (FormValue formValue : property.getFormValues()) {
                    ObjectNode valueNode = this.objectMapper.createObjectNode();
                    valueNode.put("value", formValue.getName());
                    valuesNode.add((JsonNode)valueNode);
                }
                propertyItemNode.put("enumValues", (JsonNode)valuesNode);
            }
            propertyItemNode.put("required", property.isRequired());
            propertyItemNode.put("readable", property.isReadable());
            propertyItemNode.put("writable", property.isWriteable());
            propertiesArrayNode.add((JsonNode)propertyItemNode);
        }
        formPropertiesNode.put("formProperties", (JsonNode)propertiesArrayNode);
        propertiesNode.put("formproperties", (JsonNode)formPropertiesNode);
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode) {
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("name", extension.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                propertyItemNode.put("stringValue", extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)extension.getExpression())) {
                propertyItemNode.put("expression", extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.put("fields", (JsonNode)itemsNode);
        propertiesNode.put("servicetaskfields", (JsonNode)fieldExtensionsNode);
    }

    protected void addEventProperties(Event event, ObjectNode propertiesNode) {
        List eventDefinitions = event.getEventDefinitions();
        if (eventDefinitions.size() == 1) {
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)errorDefinition.getErrorCode())) {
                    propertiesNode.put("errorref", errorDefinition.getErrorCode());
                }
            } else if (eventDefinition instanceof SignalEventDefinition) {
                SignalEventDefinition signalDefinition = (SignalEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)signalDefinition.getSignalRef())) {
                    propertiesNode.put("signalref", signalDefinition.getSignalRef());
                }
            } else if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getMessageRef())) {
                    propertiesNode.put("messageref", messageDefinition.getMessageRef());
                }
            } else if (eventDefinition instanceof TimerEventDefinition) {
                TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
                    propertiesNode.put("timerdurationdefinition", timerDefinition.getTimeDuration());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
                    propertiesNode.put("timercycledefinition", timerDefinition.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
                    propertiesNode.put("timerdatedefinition", timerDefinition.getTimeDate());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getEndDate())) {
                    propertiesNode.put("timerenddatedefinition", timerDefinition.getEndDate());
                }
            }
        }
    }

    protected void convertJsonToFormProperties(JsonNode objectNode, BaseElement element) {
        JsonNode propertiesArray;
        JsonNode formPropertiesNode = this.getProperty("formproperties", objectNode);
        if (formPropertiesNode != null && (propertiesArray = (formPropertiesNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(formPropertiesNode)).get("formProperties")) != null) {
            for (JsonNode formNode : propertiesArray) {
                JsonNode enumValuesNode;
                JsonNode formIdNode = formNode.get("id");
                if (formIdNode == null || !StringUtils.isNotEmpty((CharSequence)formIdNode.asText())) continue;
                FormProperty formProperty = new FormProperty();
                formProperty.setId(formIdNode.asText());
                formProperty.setName(this.getValueAsString("name", formNode));
                formProperty.setType(this.getValueAsString("type", formNode));
                formProperty.setExpression(this.getValueAsString("expression", formNode));
                formProperty.setVariable(this.getValueAsString("variable", formNode));
                if ("date".equalsIgnoreCase(formProperty.getType())) {
                    formProperty.setDatePattern(this.getValueAsString("datePattern", formNode));
                } else if ("enum".equalsIgnoreCase(formProperty.getType()) && (enumValuesNode = formNode.get("enumValues")) != null) {
                    ArrayList<FormValue> formValueList = new ArrayList<FormValue>();
                    for (JsonNode enumNode : enumValuesNode) {
                        if (enumNode.get("value") == null || enumNode.get("value").isNull()) continue;
                        FormValue formValue = new FormValue();
                        formValue.setId(enumNode.get("value").asText());
                        formValue.setName(enumNode.get("value").asText());
                        formValueList.add(formValue);
                    }
                    formProperty.setFormValues(formValueList);
                }
                formProperty.setRequired(this.getValueAsBoolean("required", formNode));
                formProperty.setReadable(this.getValueAsBoolean("readable", formNode));
                formProperty.setWriteable(this.getValueAsBoolean("writable", formNode));
                if (element instanceof StartEvent) {
                    ((StartEvent)element).getFormProperties().add(formProperty);
                    continue;
                }
                if (!(element instanceof UserTask)) continue;
                ((UserTask)element).getFormProperties().add(formProperty);
            }
        }
    }

    protected void convertJsonToTimerDefinition(JsonNode objectNode, Event event) {
        String timeDate = this.getPropertyValueAsString("timerdatedefinition", objectNode);
        String timeCycle = this.getPropertyValueAsString("timercycledefinition", objectNode);
        String timeDuration = this.getPropertyValueAsString("timerdurationdefinition", objectNode);
        String endDate = this.getPropertyValueAsString("timerenddatedefinition", objectNode);
        TimerEventDefinition eventDefinition = new TimerEventDefinition();
        if (StringUtils.isNotEmpty((CharSequence)timeDate)) {
            eventDefinition.setTimeDate(timeDate);
        } else if (StringUtils.isNotEmpty((CharSequence)timeCycle)) {
            eventDefinition.setTimeCycle(timeCycle);
        } else if (StringUtils.isNotEmpty((CharSequence)timeDuration)) {
            eventDefinition.setTimeDuration(timeDuration);
        }
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            eventDefinition.setEndDate(endDate);
        }
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToSignalDefinition(JsonNode objectNode, Event event) {
        String signalRef = this.getPropertyValueAsString("signalref", objectNode);
        SignalEventDefinition eventDefinition = new SignalEventDefinition();
        eventDefinition.setSignalRef(signalRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToMessageDefinition(JsonNode objectNode, Event event) {
        String messageRef = this.getPropertyValueAsString("messageref", objectNode);
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        eventDefinition.setMessageRef(messageRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToErrorDefinition(JsonNode objectNode, Event event) {
        String errorRef = this.getPropertyValueAsString("errorref", objectNode);
        ErrorEventDefinition eventDefinition = new ErrorEventDefinition();
        eventDefinition.setErrorCode(errorRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected boolean getValueAsBoolean(String name, JsonNode objectNode) {
        boolean propertyValue = false;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asBoolean();
        }
        return propertyValue;
    }

    protected List<String> getValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode valuesNode = objectNode.get(name);
        if (valuesNode != null) {
            for (JsonNode valueNode : valuesNode) {
                if (valueNode.get("value") == null || valueNode.get("value").isNull()) continue;
                resultList.add(valueNode.get("value").asText());
            }
        }
        return resultList;
    }

    protected void addField(String name, JsonNode elementNode, ServiceTask task) {
        FieldExtension field = new FieldExtension();
        field.setFieldName(name.substring(8));
        String value = this.getPropertyValueAsString(name, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if ((value.contains("${") || value.contains("#{")) && value.contains("}")) {
                field.setExpression(value);
            } else {
                field.setStringValue(value);
            }
            task.getFieldExtensions().add(field);
        }
    }

    protected void addField(String name, String propertyName, JsonNode elementNode, ServiceTask task) {
        FieldExtension field = new FieldExtension();
        field.setFieldName(name);
        String value = this.getPropertyValueAsString(propertyName, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if ((value.contains("${") || value.contains("#{")) && value.contains("}")) {
                field.setExpression(value);
            } else {
                field.setStringValue(value);
            }
            task.getFieldExtensions().add(field);
        }
    }

    protected String getPropertyValueAsString(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsString(name, objectNode);
    }

    protected boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode);
    }

    protected List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsList(name, objectNode);
    }

    protected JsonNode getProperty(String name, JsonNode objectNode) {
        return JsonConverterUtil.getProperty(name, objectNode);
    }

    protected String convertListToCommaSeparatedString(List<String> stringList) {
        String resultString = null;
        if (stringList != null && stringList.size() > 0) {
            StringBuilder expressionBuilder = new StringBuilder();
            for (String singleItem : stringList) {
                if (expressionBuilder.length() > 0) {
                    expressionBuilder.append(",");
                }
                expressionBuilder.append(singleItem);
            }
            resultString = expressionBuilder.toString();
        }
        return resultString;
    }
}

