/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.dromara.easyes.common.enums.SchemaEnum;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class RestHighLevelClientUtils {
    public static final String DEFAULT_DS = "DEFAULT_DS";
    private static final Map<String, RestHighLevelClient> restHighLevelClientMap = new ConcurrentHashMap<String, RestHighLevelClient>();

    public static RestHighLevelClient getRestHighLevelClient(String restHighLevelClientId) {
        if (DEFAULT_DS.equals(restHighLevelClientId)) {
            return restHighLevelClientMap.values().stream().findFirst().orElseThrow(() -> ExceptionUtils.eee("Could not found RestHighLevelClient,restHighLevelClientId:%s", restHighLevelClientId));
        }
        RestHighLevelClient restHighLevelClient = restHighLevelClientMap.get(restHighLevelClientId);
        if (restHighLevelClient == null) {
            LogUtils.formatError("restHighLevelClientId: %s can not find any data source, please check your config", restHighLevelClientId);
            throw ExceptionUtils.eee("Cloud not found RestHighLevelClient,restHighLevelClientId:%s", restHighLevelClientId);
        }
        return restHighLevelClient;
    }

    public RestHighLevelClient getClient(String restHighLevelClientId) {
        return RestHighLevelClientUtils.getRestHighLevelClient(restHighLevelClientId);
    }

    public static void registerRestHighLevelClient(String restHighLevelClientId, RestHighLevelClient restHighLevelClient) {
        restHighLevelClientMap.putIfAbsent(restHighLevelClientId, restHighLevelClient);
    }

    public static RestHighLevelClient restHighLevelClient(EasyEsProperties easyEsConfigProperties) {
        String address = easyEsConfigProperties.getAddress();
        if (StringUtils.isEmpty(address)) {
            throw ExceptionUtils.eee("please config the es address");
        }
        if (!address.contains(":")) {
            throw ExceptionUtils.eee("the address must contains port and separate by ':'");
        }
        String schema = StringUtils.isEmpty(easyEsConfigProperties.getSchema()) ? "http" : easyEsConfigProperties.getSchema();
        ArrayList hostList = new ArrayList();
        Arrays.stream(easyEsConfigProperties.getAddress().split(",")).forEach(item -> hostList.add(new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), schema)));
        HttpHost[] httpHost = hostList.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getKeepAliveMillis()).ifPresent(p -> httpClientBuilder.setKeepAliveStrategy((response, context) -> p.intValue()));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnTotal()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnTotal(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnPerRoute()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnPerRoute(arg_0));
            String username = easyEsConfigProperties.getUsername();
            String password = easyEsConfigProperties.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if (SchemaEnum.https.name().equals(schema)) {
                try {
                    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClientBuilder.disableAuthCaching();
                    httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
                }
                catch (Exception e) {
                    LogUtils.error("restHighLevelClient build SSLContext exception: %s", e.getMessage());
                    e.printStackTrace();
                    throw ExceptionUtils.eee(e);
                }
            }
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getConnectTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getSocketTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getConnectionRequestTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
            return requestConfigBuilder;
        });
        return new RestHighLevelClient(builder);
    }
}

