/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.http.HttpPipelinedMessage;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpPipeliningAggregator;
import org.elasticsearch.http.nio.NettyListener;
import org.elasticsearch.http.nio.NioHttpResponse;

public class NioHttpPipeliningHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private final HttpPipeliningAggregator<NioHttpResponse, NettyListener> aggregator;

    public NioHttpPipeliningHandler(Logger logger, int maxEventsHeld) {
        this.logger = logger;
        this.aggregator = new HttpPipeliningAggregator(maxEventsHeld);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof FullHttpRequest) : "Invalid message type: " + msg.getClass();
        HttpPipelinedRequest pipelinedRequest = this.aggregator.read((Object)((FullHttpRequest)msg));
        ctx.fireChannelRead((Object)pipelinedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof NioHttpResponse) : "Invalid message type: " + msg.getClass();
        NioHttpResponse response = (NioHttpResponse)((Object)msg);
        boolean success = false;
        try {
            NettyListener listener = NettyListener.fromChannelPromise(promise);
            List readyResponses = this.aggregator.write((HttpPipelinedMessage)response, (Object)listener);
            success = true;
            for (Tuple responseToWrite : readyResponses) {
                ctx.write(responseToWrite.v1(), (ChannelPromise)responseToWrite.v2());
            }
        }
        catch (IllegalStateException e) {
            ctx.channel().close();
        }
        finally {
            if (!success) {
                promise.setFailure((Throwable)new ClosedChannelException());
            }
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        List inflightResponses = this.aggregator.removeAllInflightResponses();
        if (!inflightResponses.isEmpty()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            for (Tuple inflightResponse : inflightResponses) {
                try {
                    ((NettyListener)inflightResponse.v2()).setFailure(closedChannelException);
                }
                catch (RuntimeException e) {
                    this.logger.error("unexpected error while releasing pipelined http responses", (Throwable)e);
                }
            }
        }
        ctx.close(promise);
    }
}

