/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.common.xcontent.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import shadow.fasterxml.jackson.core.JsonEncoding;
import shadow.fasterxml.jackson.core.JsonFactory;
import shadow.fasterxml.jackson.core.JsonGenerator;
import shadow.fasterxml.jackson.core.JsonParser;
import shadow.org.elasticsearch.common.xcontent.DeprecationHandler;
import shadow.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import shadow.org.elasticsearch.common.xcontent.XContent;
import shadow.org.elasticsearch.common.xcontent.XContentBuilder;
import shadow.org.elasticsearch.common.xcontent.XContentGenerator;
import shadow.org.elasticsearch.common.xcontent.XContentParser;
import shadow.org.elasticsearch.common.xcontent.XContentType;
import shadow.org.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import shadow.org.elasticsearch.common.xcontent.json.JsonXContentParser;

public class JsonXContent
implements XContent {
    private static final JsonFactory jsonFactory = new JsonFactory();
    public static final JsonXContent jsonXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(jsonXContent);
    }

    private JsonXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.JSON;
    }

    @Override
    public byte streamSeparator() {
        return 10;
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new JsonXContentGenerator(jsonFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(content));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return this.createParser(xContentRegistry, deprecationHandler, data, 0, data.length);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(new ByteArrayInputStream(data, offset, length)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(reader));
    }

    static {
        jsonFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        jsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        jsonXContent = new JsonXContent();
    }
}

