/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.solr;

import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.solr.SolrProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SolrServer.class})
@EnableConfigurationProperties(value={SolrProperties.class})
public class SolrAutoConfiguration {
    @Autowired
    private SolrProperties properties;
    private SolrServer solrServer;

    @PreDestroy
    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SolrServer solrServer() {
        this.solrServer = this.createSolrServer();
        return this.solrServer;
    }

    private SolrServer createSolrServer() {
        if (StringUtils.hasText((String)this.properties.getZkHost())) {
            return new CloudSolrServer(this.properties.getZkHost());
        }
        return new HttpSolrServer(this.properties.getHost());
    }
}

