/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfigurationScanRegistrar;
import org.springframework.boot.autoconfigure.integration.IntegrationDataSourceInitializer;
import org.springframework.boot.autoconfigure.integration.IntegrationProperties;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.jdbc.store.JdbcMessageStore;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EnableIntegration.class})
@EnableConfigurationProperties(value={IntegrationProperties.class})
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
public class IntegrationAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={JdbcMessageStore.class})
    @ConditionalOnSingleCandidate(value=DataSource.class)
    protected static class IntegrationJdbcConfiguration {
        protected IntegrationJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IntegrationDataSourceInitializer integrationDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, IntegrationProperties properties) {
            return new IntegrationDataSourceInitializer(dataSource, resourceLoader, properties);
        }
    }

    @ConditionalOnMissingBean(value={GatewayProxyFactoryBean.class})
    @Import(value={IntegrationAutoConfigurationScanRegistrar.class})
    protected static class IntegrationComponentScanConfiguration {
        protected IntegrationComponentScanConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
    protected static class IntegrationManagementConfiguration {
        protected IntegrationManagementConfiguration() {
        }

        @Configuration
        @EnableIntegrationManagement(defaultCountsEnabled="true")
        protected static class EnableIntegrationManagementConfiguration {
            protected EnableIntegrationManagementConfiguration() {
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnBean(value={MBeanServer.class})
    @ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class IntegrationJmxConfiguration
    implements EnvironmentAware,
    BeanFactoryAware {
        private BeanFactory beanFactory;
        private Environment environment;

        protected IntegrationJmxConfiguration() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        @Bean
        public IntegrationMBeanExporter integrationMbeanExporter() {
            IntegrationMBeanExporter exporter = new IntegrationMBeanExporter();
            String defaultDomain = this.environment.getProperty("spring.jmx.default-domain");
            if (StringUtils.hasLength((String)defaultDomain)) {
                exporter.setDefaultDomain(defaultDomain);
            }
            String serverBean = this.environment.getProperty("spring.jmx.server", "mbeanServer");
            exporter.setServer((MBeanServer)this.beanFactory.getBean(serverBean, MBeanServer.class));
            return exporter;
        }
    }

    @Configuration
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }
    }
}

