/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.springframework.boot.autoconfigure.jms.activemq.PooledConnectionFactoryProperties;

public class PooledConnectionFactoryFactory {
    private final PooledConnectionFactoryProperties properties;

    public PooledConnectionFactoryFactory(PooledConnectionFactoryProperties properties) {
        this.properties = properties;
    }

    public PooledConnectionFactory createPooledConnectionFactory(ConnectionFactory connectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionFactory((Object)connectionFactory);
        pooledConnectionFactory.setBlockIfSessionPoolIsFull(this.properties.isBlockIfFull());
        if (this.properties.getBlockIfFullTimeout() != null) {
            pooledConnectionFactory.setBlockIfSessionPoolIsFullTimeout(this.properties.getBlockIfFullTimeout().toMillis());
        }
        pooledConnectionFactory.setCreateConnectionOnStartup(this.properties.isCreateConnectionOnStartup());
        if (this.properties.getExpiryTimeout() != null) {
            pooledConnectionFactory.setExpiryTimeout(this.properties.getExpiryTimeout().toMillis());
        }
        if (this.properties.getIdleTimeout() != null) {
            pooledConnectionFactory.setIdleTimeout((int)this.properties.getIdleTimeout().toMillis());
        }
        pooledConnectionFactory.setMaxConnections(this.properties.getMaxConnections());
        pooledConnectionFactory.setMaximumActiveSessionPerConnection(this.properties.getMaximumActiveSessionPerConnection());
        pooledConnectionFactory.setReconnectOnException(this.properties.isReconnectOnException());
        if (this.properties.getTimeBetweenExpirationCheck() != null) {
            pooledConnectionFactory.setTimeBetweenExpirationCheckMillis(this.properties.getTimeBetweenExpirationCheck().toMillis());
        }
        pooledConnectionFactory.setUseAnonymousProducers(this.properties.isUseAnonymousProducers());
        return pooledConnectionFactory;
    }
}

