/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.time.Duration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.converter.RecordMessageConverter;

public class ConcurrentKafkaListenerContainerFactoryConfigurer {
    private KafkaProperties properties;
    private RecordMessageConverter messageConverter;
    private KafkaTemplate<Object, Object> replyTemplate;

    void setKafkaProperties(KafkaProperties properties) {
        this.properties = properties;
    }

    void setMessageConverter(RecordMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setReplyTemplate(KafkaTemplate<Object, Object> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    public void configure(ConcurrentKafkaListenerContainerFactory<Object, Object> listenerFactory, ConsumerFactory<Object, Object> consumerFactory) {
        listenerFactory.setConsumerFactory(consumerFactory);
        this.configureListenerFactory(listenerFactory);
        this.configureContainer(listenerFactory.getContainerProperties());
    }

    private void configureListenerFactory(ConcurrentKafkaListenerContainerFactory<Object, Object> factory) {
        PropertyMapper map = PropertyMapper.get();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getConcurrency).whenNonNull().to(arg_0 -> factory.setConcurrency(arg_0));
        map.from(() -> this.messageConverter).whenNonNull().to(arg_0 -> factory.setMessageConverter(arg_0));
        map.from(() -> this.replyTemplate).whenNonNull().to(arg_0 -> factory.setReplyTemplate(arg_0));
        map.from(properties::getType).whenEqualTo((Object)KafkaProperties.Listener.Type.BATCH).toCall(() -> factory.setBatchListener(Boolean.valueOf(true)));
    }

    private void configureContainer(ContainerProperties container) {
        PropertyMapper map = PropertyMapper.get();
        KafkaProperties.Listener properties = this.properties.getListener();
        map.from(properties::getAckMode).whenNonNull().to(arg_0 -> ((ContainerProperties)container).setAckMode(arg_0));
        map.from(properties::getClientId).whenNonNull().to(arg_0 -> ((ContainerProperties)container).setClientId(arg_0));
        map.from(properties::getAckCount).whenNonNull().to(arg_0 -> ((ContainerProperties)container).setAckCount(arg_0));
        map.from(properties::getAckTime).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setAckTime(arg_0));
        map.from(properties::getPollTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setPollTimeout(arg_0));
        map.from(properties::getNoPollThreshold).whenNonNull().to(arg_0 -> ((ContainerProperties)container).setNoPollThreshold(arg_0));
        map.from(properties::getIdleEventInterval).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((ContainerProperties)container).setIdleEventInterval(arg_0));
        map.from(properties::getMonitorInterval).whenNonNull().as(Duration::getSeconds).as(Number::intValue).to(arg_0 -> ((ContainerProperties)container).setMonitorInterval(arg_0));
        map.from(properties::getLogContainerConfig).whenNonNull().to(arg_0 -> ((ContainerProperties)container).setLogContainerConfig(arg_0));
    }
}

