/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import com.mongodb.reactivestreams.client.MongoClient;
import io.netty.channel.socket.SocketChannel;
import java.util.List;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.ReactiveMongoClientFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;

@Configuration
@ConditionalOnClass(value={MongoClient.class, Flux.class})
@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoReactiveAutoConfiguration {
    private final MongoClientSettings settings;
    private MongoClient mongo;

    public MongoReactiveAutoConfiguration(ObjectProvider<MongoClientSettings> settings) {
        this.settings = (MongoClientSettings)settings.getIfAvailable();
    }

    @PreDestroy
    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoClient reactiveStreamsMongoClient(MongoProperties properties, Environment environment, ObjectProvider<List<MongoClientSettingsBuilderCustomizer>> builderCustomizers) {
        ReactiveMongoClientFactory factory = new ReactiveMongoClientFactory(properties, environment, (List)builderCustomizers.getIfAvailable());
        this.mongo = factory.createMongoClient(this.settings);
        return this.mongo;
    }

    @Configuration
    @ConditionalOnClass(value={SocketChannel.class})
    static class NettyDriverConfiguration {
        NettyDriverConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        public MongoClientSettingsBuilderCustomizer nettyDriverCustomizer(ObjectProvider<MongoClientSettings> settings) {
            return builder -> {
                if (!this.isStreamFactoryFactoryDefined((MongoClientSettings)settings.getIfAvailable())) {
                    builder.streamFactoryFactory((StreamFactoryFactory)NettyStreamFactoryFactory.builder().build());
                }
            };
        }

        private boolean isStreamFactoryFactoryDefined(MongoClientSettings settings) {
            return settings != null && settings.getStreamFactoryFactory() != null;
        }
    }
}

