/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.webservices.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.webservices.client.WebServiceTemplateBuilder;
import org.springframework.boot.webservices.client.WebServiceTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.client.core.WebServiceTemplate;

@Configuration
@ConditionalOnClass(value={WebServiceTemplate.class, Unmarshaller.class, Marshaller.class})
public class WebServiceTemplateAutoConfiguration {
    private final ObjectProvider<List<WebServiceTemplateCustomizer>> webServiceTemplateCustomizers;

    public WebServiceTemplateAutoConfiguration(ObjectProvider<List<WebServiceTemplateCustomizer>> webServiceTemplateCustomizers) {
        this.webServiceTemplateCustomizers = webServiceTemplateCustomizers;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebServiceTemplateBuilder webServiceTemplateBuilder() {
        WebServiceTemplateBuilder builder = new WebServiceTemplateBuilder(new WebServiceTemplateCustomizer[0]);
        ArrayList customizers = (ArrayList)this.webServiceTemplateCustomizers.getIfAvailable();
        if (!CollectionUtils.isEmpty((Collection)customizers)) {
            customizers = new ArrayList(customizers);
            AnnotationAwareOrderComparator.sort(customizers);
            builder = builder.customizers(customizers);
        }
        return builder;
    }
}

