/*
 * Decompiled with CFR 0.152.
 */
package com.anbang.galaxy.sso.plugin;

import com.anbang.galaxy.sso.plugin.SSOPluginFilterConfigureConstants;
import com.anbang.galaxy.sso.plugin.SSOPluginFilterConfigurer;
import com.anbang.galaxy.sso.plugin.SSOPluginSecurityFilter;
import com.anbang.galaxy.sso.plugin.SSOPluginSecurityUtils;
import com.anbang.galaxy.sso.plugin.domain.CoreMember;
import com.anbang.galaxy.sso.plugin.domain.SSOPluginActionContext;
import com.anbang.galaxy.sso.plugin.domain.WebUserOAuthSession;
import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.rapid.j2ee.framework.mvc.security.logic.AbstractRequestCertificationSNSecurityAuthority;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSOPluginFilterHandler
implements SSOPluginFilterConfigureConstants {
    private String authCode;
    private WebUserOAuthSession webUserOAuthSession;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private SSOPluginFilterConfigurer ssoPluginFilterConfigurer;
    private static Log Logger = LogFactory.getLog(SSOPluginFilterHandler.class);

    public SSOPluginFilterHandler(SSOPluginActionContext ssoPluginActionContext) {
        this.request = ssoPluginActionContext.getRequest();
        this.response = ssoPluginActionContext.getResponse();
        this.ssoPluginFilterConfigurer = SSOPluginFilterConfigurer.getSSOPluginFilterConfigurer();
        this.authCode = this.request.getParameter(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.AuthorityCode.ParameterName"));
        this.webUserOAuthSession = new WebUserOAuthSession(this.request.getParameter(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.TokenId.ParameterName")), this.request.getParameter(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.RefreshTokenId.ParameterName")));
    }

    public boolean process() {
        if (this.hasAuthCodeParameter()) {
            this.injectWebUserOAuthSessionByAuthCode();
        }
        if (this.hasTokenParameter()) {
            this.injectCoreAccountSessionByOAuthSession();
        }
        return this.doGotoSecurityAuthroityLogin();
    }

    private void injectWebUserOAuthSessionByAuthCode() {
        if (SSOPluginSecurityUtils.isLoginStatus()) {
            return;
        }
        this.webUserOAuthSession = SSOPluginSecurityFilter.getSSOPluginSecurityFetcher().getWebUserOAuthSessionByAuthorityCode(this.authCode);
    }

    private void injectCoreAccountSessionByOAuthSession() {
        if (SSOPluginSecurityUtils.isLoginStatus()) {
            return;
        }
        try {
            CoreMember coreMemberUser = SSOPluginSecurityFilter.getSSOPluginSecurityFetcher().getCoreMemberByOAthoSession(this.webUserOAuthSession);
            coreMemberUser.setWebUserOAuthoritySession(this.webUserOAuthSession);
            SSOPluginSecurityUtils.saveCoreMemberUserSession(coreMemberUser, this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.WebUser.Session.MaxInactiveInterval"));
        }
        catch (Throwable e) {
            Logger.error((Object)e);
        }
    }

    private boolean doGotoSecurityAuthroityLogin() {
        if (!this.ssoPluginFilterConfigurer.isBoolean("SSOPluginFilterConfigure.InspectSessionTimeout")) {
            return true;
        }
        if (SSOPluginSecurityUtils.isLoginStatus()) {
            return true;
        }
        this.request.setAttribute("LoginFormAction", (Object)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.LoginActonFormPage.Action"));
        this.request.setAttribute("PlatformId", (Object)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.PlatformId"));
        String sn = UUIDGenerator.nextUUID();
        this.request.setAttribute("SN", (Object)sn);
        this.request.setAttribute("Hashcode", (Object)CryptologyFactory.getSingleCryptology((CryptologyType)CryptologyType.Md5).encrypt(String.valueOf(sn) + this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.PlatformId") + "AutoLoginInitPage" + AbstractRequestCertificationSNSecurityAuthority.getSecuritySaltByApplicationName((String)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.PlatformId"))));
        this.request.setAttribute("BindId", (Object)this.request.getParameter(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.BindId.ParameterName")));
        this.request.setAttribute("BindType", (Object)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.BindType"));
        this.request.setAttribute("BackUrl", (Object)this.getRequestBackUrl());
        try {
            this.request.getRequestDispatcher(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.LoginActonFormPage.PhysicalLocation")).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (Exception e) {
            Logger.error((Object)e);
            this.doErrorProcess(e.getMessage());
        }
        return false;
    }

    private void doErrorProcess(String error) {
        try {
            this.response.setContentType("text/html");
            this.response.setCharacterEncoding(this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.Url.Charset"));
            PrintWriter out = this.response.getWriter();
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<HTML>");
            out.println("  <HEAD><TITLE>\u7cfb\u7edf\u5f02\u5e38</TITLE></HEAD>");
            out.println("  <BODY>");
            out.println(error);
            out.println("  </BODY>");
            out.println("</HTML>");
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getRequestBackUrl() {
        StringBuffer requestUrl = new StringBuffer(500);
        requestUrl.append(this.request.getRequestURL());
        requestUrl.append("?");
        for (Object key : this.request.getParameterMap().keySet()) {
            String[] stringArray = this.request.getParameterValues((String)key);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                requestUrl.append(key + "=" + value + "&");
                ++n2;
            }
        }
        requestUrl.append("1=1");
        try {
            return URLEncoder.encode(requestUrl.toString(), this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.Url.Charset"));
        }
        catch (UnsupportedEncodingException e) {
            return requestUrl.toString();
        }
    }

    private boolean hasAuthCodeParameter() {
        return !TypeChecker.isEmpty((String)this.authCode);
    }

    private boolean hasTokenParameter() {
        return this.webUserOAuthSession != null && !TypeChecker.isEmpty((String)this.webUserOAuthSession.getAccessToken());
    }
}

