/*
 * Decompiled with CFR 0.152.
 */
package com.anbang.galaxy.sso.plugin;

import com.anbang.galaxy.sso.plugin.HttpClient;
import com.anbang.galaxy.sso.plugin.SSOPluginFilterConfigureConstants;
import com.anbang.galaxy.sso.plugin.SSOPluginFilterConfigurer;
import com.anbang.galaxy.sso.plugin.domain.CoreMember;
import com.anbang.galaxy.sso.plugin.domain.OperateResult;
import com.anbang.galaxy.sso.plugin.domain.WebUserOAuthSession;
import com.anbang.galaxy.sso.plugin.exception.SSOPluginResultException;
import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.io.xml.BeanXmlUtils;
import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.rapid.j2ee.framework.mvc.exception.SessionTimeoutApplicationException;
import com.rapid.j2ee.framework.mvc.security.logic.AbstractRequestCertificationSNSecurityAuthority;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class SSOPluginSecurityFetcher
implements SSOPluginFilterConfigureConstants {
    private String configurerPath;
    private SSOPluginFilterConfigurer ssoPluginFilterConfigurer;
    private static Log log = LogFactory.getLog(SSOPluginSecurityFetcher.class);

    public CoreMember getCoreMemberByTokens(String tokenId, String refreshTokenId) {
        WebUserOAuthSession oAuthSession = new WebUserOAuthSession();
        oAuthSession.setAccessToken(tokenId);
        oAuthSession.setRefreshToken(refreshTokenId);
        CoreMember coreMember = this.getCoreMemberByOAthoSession(oAuthSession);
        coreMember.setRefreshTokenId(refreshTokenId);
        return coreMember;
    }

    public CoreMember getCoreMemberByOAthoSession(WebUserOAuthSession oAuthSession) {
        this.initSSOPluginFilterConfigurer();
        try {
            return this.getCoreMemberByTokenId(oAuthSession.getAccessToken());
        }
        catch (SessionTimeoutApplicationException e) {
            oAuthSession.refreshToken(this.getOAuthSessionByRefreshToke(oAuthSession.getRefreshToken()));
            return this.getCoreMemberByTokenId(oAuthSession.getAccessToken());
        }
    }

    public WebUserOAuthSession getWebUserOAuthSessionByAuthorityCode(String authCode) {
        this.initSSOPluginFilterConfigurer();
        if (TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            throw new IllegalArgumentException("Please set configurer Path (setConfigurerPath()) before use it!");
        }
        String retrieveTokenUrl = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.RetrieveTokenIdByAuthorityCode.Url");
        return this.getWebUserOAuthSessionByUrl(StringUtils.replace((String)retrieveTokenUrl, (String)"{authCode}", (String)authCode));
    }

    public WebUserOAuthSession getOAuthSessionByRefreshToke(String refreshToken) {
        if (TypeChecker.isEmpty((String)refreshToken)) {
            throw new SessionTimeoutApplicationException();
        }
        this.initSSOPluginFilterConfigurer();
        if (TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            throw new IllegalArgumentException("Please set configurer Path (setConfigurerPath()) before use it!");
        }
        String retrieveTokenUrl = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.RetrieveTokenIdByRefreshToken.Url");
        return this.getWebUserOAuthSessionByUrl(StringUtils.replace((String)retrieveTokenUrl, (String)"{refreshToken}", (String)refreshToken));
    }

    public CoreMember getCoreMemberByTokenId(String tokenId) {
        this.initSSOPluginFilterConfigurer();
        if (TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            throw new IllegalArgumentException("Please set configurer Path (setConfigurerPath()) before use it!");
        }
        String retrieveWebUserUrl = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.RetrieveWebUserByTokenId.Url");
        CoreMember coreMember = this.getCoreMemberByUrl(StringUtils.replace((String)retrieveWebUserUrl, (String)"{tokenId}", (String)tokenId));
        coreMember.setTokenId(tokenId);
        return coreMember;
    }

    public CoreMember getCoreMemberByMemberId(String memberId) {
        this.initSSOPluginFilterConfigurer();
        if (TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            throw new IllegalArgumentException("Please set configurer Path (setConfigurerPath()) before use it!");
        }
        String retrieveWebUserUrl = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.RetrieveWebUserByMemberId.Url");
        HashMap<String, String> dynamicParameters = new HashMap<String, String>(3);
        dynamicParameters.put("memberId", memberId);
        String sn = UUIDGenerator.nextUUID();
        dynamicParameters.put("sn", sn);
        dynamicParameters.put("hashcode", CryptologyFactory.getSingleCryptology((CryptologyType)CryptologyType.Md5).encrypt(String.valueOf(sn) + this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.PlatformId") + "GetMemberUserByMemberId" + AbstractRequestCertificationSNSecurityAuthority.getSecuritySaltByApplicationName((String)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.PlatformId"))));
        return this.getCoreMemberByUrl(StringUtils.replaceAll((String)retrieveWebUserUrl, dynamicParameters, (String)"{", (String)"}"));
    }

    public OperateResult logout(String tokenId, String refreshTokenId) {
        Assert.hasLength((String)tokenId, (String)"The param 'tokenId' can not be empty!");
        Assert.hasLength((String)refreshTokenId, (String)"The param 'refreshTokenId' can not be empty!");
        this.initSSOPluginFilterConfigurer();
        if (TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            throw new IllegalArgumentException("Please set configurer Path (setConfigurerPath()) before use it!");
        }
        String bindType = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.BindType");
        String url = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.Logout.Url").replace("{tokenId}", tokenId).replace("{refreshToken}", refreshTokenId).replace("{bindType}", bindType);
        String resultXml = HttpClient.post(url);
        XNode node = new XPathParser(resultXml).evalNode("output/head");
        String resultClassName = this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.OperateResult.ClassName");
        return (OperateResult)ConstructorUtils.newInstance((String)resultClassName, (Class[])new Class[]{String.class, String.class, String.class}, (Object[])new String[]{node.evalNodeBodyString("code"), node.evalNodeBodyString("message"), node.evalNodeBodyString("message-key")});
    }

    private WebUserOAuthSession getWebUserOAuthSessionByUrl(String url) {
        log.info((Object)("\n\nget WebUserOAuthSession \n\t url:" + url));
        String returnXml = HttpClient.post(url);
        log.info((Object)(" \n\t result xml :" + returnXml));
        XPathParser xPathParser = new XPathParser(returnXml);
        String returnCode = xPathParser.evalNode("output/head/code").getStringBody();
        if (!"0".equalsIgnoreCase(returnCode)) {
            throw new SSOPluginResultException(xPathParser);
        }
        return (WebUserOAuthSession)BeanXmlUtils.bean(WebUserOAuthSession.class, (XNode)xPathParser.evalNode("output/body/webServiceSession"));
    }

    private CoreMember getCoreMemberByUrl(String url) {
        log.info((Object)("\n\nget CoreMember \n\t url:" + url));
        String returnXml = HttpClient.post(url);
        log.info((Object)(" \n\t result xml :" + returnXml));
        XPathParser xPathParser = new XPathParser(returnXml);
        String returnCode = xPathParser.evalNode("output/head/code").getStringBody();
        if (String.valueOf(92).equalsIgnoreCase(returnCode)) {
            throw new SessionTimeoutApplicationException();
        }
        if (!"0".equalsIgnoreCase(returnCode)) {
            throw new SSOPluginResultException(xPathParser);
        }
        return (CoreMember)BeanXmlUtils.bean((String)this.ssoPluginFilterConfigurer.getProperty("SSOPluginFilterConfigure.GalaxySSO.WebUser.ClassName"), (XNode)xPathParser.evalNode("output/body/coreMember"));
    }

    public void setConfigurerPath(String configurerPath) {
        this.configurerPath = configurerPath;
        this.initSSOPluginFilterConfigurer();
    }

    private synchronized void initSSOPluginFilterConfigurer() {
        if (!TypeChecker.isNull((Object)this.ssoPluginFilterConfigurer)) {
            return;
        }
        SSOPluginFilterConfigurer.initSSOPluginFilterConfigurer(this.configurerPath);
        this.ssoPluginFilterConfigurer = SSOPluginFilterConfigurer.getSSOPluginFilterConfigurer();
    }

    public static void main(String[] args) {
        SSOPluginSecurityFetcher ssoFetcher = new SSOPluginSecurityFetcher();
        ssoFetcher.setConfigurerPath("GalaxySSO_PluginConfigurer.properties");
        CoreMember coreMember = ssoFetcher.getCoreMemberByTokens("TK_09c9d0dca0f64712ba50c6114c8c3fb8_John_24SA4Q6th9f0794756781mq660b4D6", "RT_f188a36910c14b28a4e2e1faf893e5db_John_QmRJzSw1sh281L");
        System.out.println("coreMember ==== " + coreMember);
    }
}

