/*
 * Decompiled with CFR 0.152.
 */
package com.anbang.galaxy.sso.plugin;

import com.anbang.galaxy.sso.plugin.SSOPluginFilterConfigurer;
import com.anbang.galaxy.sso.plugin.SSOPluginFilterHandler;
import com.anbang.galaxy.sso.plugin.SSOPluginSecurityFetcher;
import com.anbang.galaxy.sso.plugin.domain.SSOPluginActionContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SSOPluginSecurityFilter
implements Filter {
    public static ThreadLocal<SSOPluginActionContext> ActionContextThreadLocal = new ThreadLocal();
    private static SSOPluginSecurityFetcher ssoPluginSecurityFetcher = null;

    public void destroy() {
        ssoPluginSecurityFetcher = null;
        ActionContextThreadLocal.remove();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            ActionContextThreadLocal.set(new SSOPluginActionContext((HttpServletRequest)request, (HttpServletResponse)response));
            if (!new SSOPluginFilterHandler(ActionContextThreadLocal.get()).process()) {
                return;
            }
            filterChain.doFilter(request, response);
        }
        finally {
            ActionContextThreadLocal.remove();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SSOPluginFilterConfigurer.initSSOPluginFilterConfigurer(filterConfig.getInitParameter("ConfigurerPath"));
        ssoPluginSecurityFetcher = new SSOPluginSecurityFetcher();
        ssoPluginSecurityFetcher.setConfigurerPath(filterConfig.getInitParameter("ConfigurerPath"));
    }

    public static SSOPluginSecurityFetcher getSSOPluginSecurityFetcher() {
        return ssoPluginSecurityFetcher;
    }
}

