/*
 * Decompiled with CFR 0.152.
 */
package com.bfb.merchant.atc;

import com.bfb.merchant.utils.CAP12CertTool;
import com.bfb.merchant.utils.HexStringByte;
import com.bfb.merchant.utils.SecurityException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSASignUtil {
    private String certFilePath = null;
    private String password = null;
    private String hexCert = null;
    private String rootCertPath = null;

    public RSASignUtil(String certFilePath, String password) {
        this.certFilePath = certFilePath;
        this.password = password;
    }

    public RSASignUtil(String rootCertPath) {
        this.rootCertPath = rootCertPath;
    }

    public RSASignUtil() {
    }

    public String sign(String indata, String encoding) throws UnsupportedEncodingException {
        String singData = null;
        if (RSASignUtil.isEmpty(encoding)) {
            encoding = "GBK";
        }
        try {
            CAP12CertTool c = new CAP12CertTool(this.certFilePath, this.password);
            X509Certificate cert = c.getCert();
            byte[] si = c.getSignData(indata.getBytes(encoding));
            byte[] cr = cert.getEncoded();
            this.hexCert = HexStringByte.byteToHex(cr);
            singData = HexStringByte.byteToHex(si);
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return singData;
    }

    public String getCertInfo() {
        return this.hexCert;
    }

    public boolean verify(String oridata, String signData, String svrCert, String encoding) {
        boolean res = false;
        if (RSASignUtil.isEmpty(encoding)) {
            encoding = "GBK";
        }
        try {
            X509Certificate cert;
            byte[] signDataBytes = HexStringByte.hexToByte(signData.getBytes());
            byte[] inDataBytes = oridata.getBytes(encoding);
            byte[] signaturepem = RSASignUtil.checkPEM(signDataBytes);
            if (signaturepem != null) {
                signDataBytes = Base64.decode((byte[])signaturepem);
            }
            if ((cert = this.getCertFromHexString(svrCert)) != null) {
                PublicKey pubKey = cert.getPublicKey();
                Signature signet = Signature.getInstance("SHA1WITHRSA");
                signet.initVerify(pubKey);
                signet.update(inDataBytes);
                res = signet.verify(signDataBytes);
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return res;
    }

    public X509Certificate getCertfromPath(String crt_path) throws SecurityException {
        X509Certificate cert = null;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(crt_path));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (CertificateException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new SecurityException(e.getMessage());
        }
        return cert;
    }

    public static PublicKey getPublicKeyfromPath(String svrCertpath) throws SecurityException {
        X509Certificate cert = null;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(svrCertpath));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (CertificateException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new SecurityException(e.getMessage());
        }
        return cert.getPublicKey();
    }

    public boolean verifyCert(X509Certificate userCert, X509Certificate rootCert) throws SecurityException {
        boolean res = false;
        try {
            PublicKey rootKey = rootCert.getPublicKey();
            userCert.checkValidity();
            userCert.verify(rootKey);
            res = true;
            if (!userCert.getIssuerDN().equals(rootCert.getSubjectDN())) {
                res = false;
            }
        }
        catch (CertificateExpiredException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (CertificateNotYetValidException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (CertificateException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new SecurityException(e.getMessage());
        }
        return res;
    }

    private X509Certificate getCertFromHexString(String hexCert) throws SecurityException {
        ByteArrayInputStream bIn = null;
        X509Certificate certobj = null;
        try {
            try {
                byte[] cert = HexStringByte.hexToByte(hexCert.getBytes());
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                bIn = new ByteArrayInputStream(cert);
                certobj = (X509Certificate)fact.generateCertificate(bIn);
                bIn.close();
                bIn = null;
            }
            catch (CertificateException e) {
                e.printStackTrace();
                try {
                    if (bIn != null) {
                        bIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bIn != null) {
                        bIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (bIn != null) {
                    bIn.close();
                }
            }
            catch (IOException iOException) {}
        }
        return certobj;
    }

    public static byte[] checkPEM(byte[] paramArrayOfByte) {
        String str1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/+= \r\n-";
        int i = 0;
        while (i < paramArrayOfByte.length) {
            if (str1.indexOf(paramArrayOfByte[i]) == -1) {
                return null;
            }
            ++i;
        }
        StringBuffer localStringBuffer = new StringBuffer(paramArrayOfByte.length);
        String str2 = new String(paramArrayOfByte);
        int j = 0;
        while (j < str2.length()) {
            if (str2.charAt(j) != ' ' && str2.charAt(j) != '\r' && str2.charAt(j) != '\n') {
                localStringBuffer.append(str2.charAt(j));
            }
            ++j;
        }
        return localStringBuffer.toString().getBytes();
    }

    public String getFormValue(String respMsg, String name) {
        String[] resArr = StringUtils.split((String)respMsg, (String)"&");
        HashMap<String, String> resMap = new HashMap<String, String>();
        int i = 0;
        while (i < resArr.length) {
            String data = resArr[i];
            int index = StringUtils.indexOf((String)data, (char)'=');
            String nm = StringUtils.substring((String)data, (int)0, (int)index);
            String val = StringUtils.substring((String)data, (int)(index + 1));
            resMap.put(nm, val);
            ++i;
        }
        return (String)resMap.get(name) == null ? "" : (String)resMap.get(name);
    }

    public String getValue(String respMsg, String name) {
        String[] resArr = StringUtils.split((String)respMsg, (String)"&");
        HashMap<String, String> resMap = new HashMap<String, String>();
        int i = 0;
        while (i < resArr.length) {
            String data = resArr[i];
            int index = StringUtils.indexOf((String)data, (char)'=');
            String nm = StringUtils.substring((String)data, (int)0, (int)index);
            String val = StringUtils.substring((String)data, (int)(index + 1));
            resMap.put(nm, val);
            ++i;
        }
        return (String)resMap.get(name) == null ? "" : (String)resMap.get(name);
    }

    public Map coverString2Map(String respMsg) {
        String[] resArr = StringUtils.split((String)respMsg, (String)"&");
        HashMap<String, String> resMap = new HashMap<String, String>();
        int i = 0;
        while (i < resArr.length) {
            String data = resArr[i];
            int index = StringUtils.indexOf((String)data, (char)'=');
            String nm = StringUtils.substring((String)data, (int)0, (int)index);
            String val = StringUtils.substring((String)data, (int)(index + 1));
            resMap.put(nm, val);
            ++i;
        }
        return resMap;
    }

    public static String coverMap2String(Map<String, String> data) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : data.entrySet()) {
            String value = "";
            if ("merchantSign".equals(en.getKey().trim()) || "serverSign".equals(en.getKey().trim()) || "serverCert".equals(en.getKey().trim())) continue;
            tree.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey() + "=" + en.getValue() + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    public static String encryptData(String dataString, String encoding, String svrCertPath) {
        byte[] data = null;
        try {
            data = RSASignUtil.encryptedPin(RSASignUtil.getPublicKeyfromPath(svrCertPath), dataString.getBytes(encoding));
            return new String(RSASignUtil.base64Encode(data), encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] encryptedPin(PublicKey publicKey, byte[] plainPin) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", (Provider)new BouncyCastleProvider());
            cipher.init(1, publicKey);
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(plainPin.length);
            int leavedSize = plainPin.length % blockSize;
            int blocksSize = leavedSize != 0 ? plainPin.length / blockSize + 1 : plainPin.length / blockSize;
            byte[] raw = new byte[outputSize * blocksSize];
            int i = 0;
            while (plainPin.length - i * blockSize > 0) {
                if (plainPin.length - i * blockSize > blockSize) {
                    cipher.doFinal(plainPin, i * blockSize, blockSize, raw, i * outputSize);
                } else {
                    cipher.doFinal(plainPin, i * blockSize, plainPin.length - i * blockSize, raw, i * outputSize);
                }
                ++i;
            }
            return raw;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static byte[] base64Encode(byte[] inputByte) throws IOException {
        return Base64.encode((byte[])inputByte);
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }
}

